% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg_gradients}
\alias{cg_gradients}
\title{Calculate Gradients}
\arguments{
\item{name}{character scalar, name of the node that is differentiated.}

\item{values}{named list or environment, values that are subsituted for the nodes in the graph.}

\item{index}{numeric scalar, index of the target node that is differentiated. Defaults to the first element.}
}
\value{
environment, the gradients of all nodes with respect to target node \code{name}.
}
\description{
Differentiate the graph with respect to node \code{name} by reverse automatic differentiation.
}
\details{
\code{$gradients(name, values = new.env(), index = 1)}
}
\note{
All nodes required to compute node \code{name} must have a value, or their value must be able to be computed at run-time. The values of nodes can be obtained by first evaluating node \code{name} in the graph using function \link[cgraph]{cg_run}. The values obtained by this function for the nodes can then be supplied to argument \code{values}.

Currently, the cgraph package can only differentiate scalar target nodes. In case the value of target node \code{name} is a vector or an array, argument \code{index} can be used to specify which element of the vector or array is to be differentiated.

The gradients of all ancestors or \code{name} are returned. Constant nodes are not differentiated and their gradients are not returned. The gradients have the same shape as the values of the nodes.

There is a wrapper function \link[cgraph]{gradients} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add some parameters.
a <- x$parm(2, name = "a")
b <- x$parm(4, name = "b")

# Perform some operations on the parameters.
c <- cg_sin(a) + cg_cos(b) - cg_tan(a)

# Differentiate the graph with respect to c.
grads <- x$gradients(c, x$run(c))

# Retrieve the gradient of c with respect to a.
grads$a

}
\author{
Ron Triepels
}
