% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IslandGA.R
\name{IslandGA}
\alias{IslandGA}
\title{Island model based genetic algorithm}
\usage{
IslandGA(
  ObjFunc,
  N,
  IslandGA_param = .default.IslandGA_param,
  IslandGA_operators = .default.operators,
  p.range = NULL,
  ...
)
}
\arguments{
\item{ObjFunc}{The fitness function to be minimized. Users can specify any R or Rcpp
functions as the fitness function with setting input as potential solution to
the optimization problem and returning a numerical value as the output/fitness.}

\item{N}{The sample size of the time series.}

\item{IslandGA_param}{A list contains the hyper-parameters for IslandGA.
The default values for these hyper-parameters are included in \code{.default.IslandGA_param}.
See \code{\link{IslandGA_param}} for the details.}

\item{IslandGA_operators}{A list includes the functions for population initialization,
new individual selection, and genetic operator of crossover and mutation.
See \code{\link{operators}} for the details and default functions.}

\item{p.range}{Default is \code{NULL} for only changepoint detection. If
\code{p.range} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{p.range}.}

\item{...}{additional arguments that will be passed to the fitness function.}
}
\value{
Returns a list that has the following components.
\item{overbestfit}{The obtained minimum value of the objective function after
the final iteration.}
\item{overbestchrom}{The locations of the detected changepoints associating
with the \code{overbestfit} the after the final iteration.}
\item{bestfit}{The minimized fitness function values at each iteration.}
\item{bestchrom}{The detected changepoints at each iteration.}
\item{countMig}{The number of migrations undertaken by the IslandGA.}
\item{count}{The number of iterations (generations) undertaken by the island
genetic algorithm model.}
\item{convg}{An integer code.
 \itemize{
   \item{0} indicates the algorithm successful completion.
   \item{1} indicates the the total number of generations exceeds the
            prespecified \code{maxgen} limit.
 }
 }
}
\description{
Perform the modified island-based genetic algorithm (IslandGA) for multiple changepoint detection.
Minimization of an objective function using genetic algorithm (GA).
The algorithm can be run sequentially or in explicit parallelisation.
}
\examples{
\donttest{N = 1000
XMatT = matrix(1, nrow=N, ncol=1)
Xt = ts.sim(beta=0.5, XMat=XMatT, sigma=1, phi=0.5, theta=NULL,
            Delta=c(2, -2), CpLoc=c(250, 750), seed=1234)
TsPlotCheck(X=1:N, Xat=seq(from=1, to=N, length=10), Y=Xt, tau=c(250, 750))

IslandGA.res = IslandGA(ObjFunc=ARIMA.BIC, N=N, XMat=XMatT, Xt=Xt)
IslandGA.res$overbestfit
IslandGA.res$overbestchrom
}
}
