% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean_online.R
\name{online.univar}
\alias{online.univar}
\title{Online change point detection with controlled false alarm rate or average run length.}
\usage{
online.univar(
  y_vec,
  b_vec = NULL,
  train_vec = NULL,
  alpha = NULL,
  gamma = NULL,
  permu_num = NULL
)
}
\arguments{
\item{y_vec}{A \code{numeric} vector of observations.}

\item{b_vec}{A \code{numeric} vector of thresholds b_t with t >= 2.}

\item{train_vec}{A \code{numeric} vector of training data from a pre-change distribution (no change point), which is only needed to when b_vec is NULL in order to calibrate b_t.}

\item{alpha}{A \code{numeric} scalar of desired false alarm rate.}

\item{gamma}{An \code{integer} scalar of desired average run length.}

\item{permu_num}{An \code{integer} scalar of number of random permutation for calibration.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_hat}{An \code{integer} scalar of estimated change point location}
 \item{b_vec}{A \code{numeric} vector of thresholds b_t with t >= 2}
}
\description{
Perform online change point detection with controlled false alarm rate or average run length.
}
\examples{
y_vec = rnorm(150) + c(rep(0, 100), rep(1, 50))
train_vec = rnorm(100)
# control the false alarm rate
temp1 = online.univar(y_vec = y_vec, train_vec = train_vec, alpha = 0.05, permu_num = 20)
temp1$cpt_hat
temp1$b_vec # calibrated threshold
}
\references{
Yu, Padilla, Wang and Rinaldo (2020) <arxiv:2006.03283>
}
\author{
Haotian Xu
}
