% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEPP.R
\name{simu.SEPP}
\alias{simu.SEPP}
\title{Simulate a (stable) SEPP model (without change point).}
\usage{
simu.SEPP(intercept, n, A, threshold, vzero = NULL)
}
\arguments{
\item{intercept}{A \code{numeric} scalar representing the intercept of the model.}

\item{n}{An \code{integer} scalar representing sample size.}

\item{A}{A \code{numeric} pXp matrix representing the coefficient matrix.}

\item{threshold}{A \code{numeric} scalar representing the upper bound for each coordinate of X_t (for stability).}

\item{vzero}{A \code{numeric} vector representing the observation at time 0. If \code{vzero = NULL}, each coordinate is generated from a Poisson distribution with mean \code{lambda}.}
}
\value{
A p-by-n matrix.
}
\description{
Simulate a (stable) SEPP model (without change point).
}
\examples{
p = 10 # dimension
n = 50
s = 5 # sparsity
factor = 0.12 # large factor gives exact recovery
threshold = 4 # thresholding makes the process stable
intercept = 1/2 # intercept of the model. Assume to be known as in the existing literature
A1 = A2 = A3 = matrix(0, p, p)
diag(A1[,-1]) = 1
diag(A1) = 1
diag(A1[-1,]) = -1
A1 = A1*factor
A1[(s+1):p, (s+1):p] = 0
diag(A2[,-1]) = 1
diag(A2) = -1
diag(A2[-1,]) = 1
A2 = A2*factor
A2[(s+1):p, (s+1):p] = 0
diag(A3[,-1]) = 1
diag(A3) = 1
diag(A3[-1,]) = -1
A3 = A3*factor
A3[(s+1):p, (s+1):p] = 0
data1 = simu.SEPP(intercept, n, A1, threshold, vzero = NULL)
data2 = simu.SEPP(intercept, n, A2, threshold, vzero = data1[,n])
data3 = simu.SEPP(intercept, n, A3, threshold, vzero = data2[,n])
data = cbind(data1, data2, data3)
dim(data)
}
\references{
Wang, Yu, & Willett (2020). Detecting Abrupt Changes in High-Dimensional Self-Exciting Poisson Processes. <arXiv:2006.03572>.
}
\author{
Daren Wang & Haotian Xu
}
