% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/company-provider.R
\name{CompanyProvider}
\alias{CompanyProvider}
\title{CompanyProvider}
\description{
company name/etc. methods
}
\examples{
x <- CompanyProvider$new()
x$locale
x$company()
x$company_suffix()
x$catch_phrase()
x$bs()

x <- CompanyProvider$new(locale = "fr_FR")
x$locale
x$company()
x$company_suffix()
x$siren()

x <- CompanyProvider$new(locale = "hr_HR")
x$locale
x$company()
x$company_suffix()

x <- CompanyProvider$new(locale = "it_IT")
x$locale
x$company()
x$company_suffix()
x$bs()

CompanyProvider$new(locale = "es_MX")$bs()
CompanyProvider$new(locale = "es_MX")$company_prefix()
CompanyProvider$new(locale = "es_MX")$catch_phrase()

CompanyProvider$new(locale = "bg_BG")$company()
CompanyProvider$new(locale = "cs_CZ")$company()
CompanyProvider$new(locale = "de_DE")$company()
CompanyProvider$new(locale = "fa_IR")$company()
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{CompanyProvider}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{locale}}{(character) xxx}

\item{\code{formats}}{(character) xxx}

\item{\code{prefixes}}{(character) xxx}

\item{\code{suffixes}}{(character) xxx}

\item{\code{catch_phrase_words}}{(character) xxx}

\item{\code{bsWords}}{(character) xxx}

\item{\code{siren_format}}{(character) xxx}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-allowed_locales}{\code{CompanyProvider$allowed_locales()}}
\item \href{#method-new}{\code{CompanyProvider$new()}}
\item \href{#method-company}{\code{CompanyProvider$company()}}
\item \href{#method-company_prefix}{\code{CompanyProvider$company_prefix()}}
\item \href{#method-company_suffix}{\code{CompanyProvider$company_suffix()}}
\item \href{#method-catch_phrase}{\code{CompanyProvider$catch_phrase()}}
\item \href{#method-bs}{\code{CompanyProvider$bs()}}
\item \href{#method-siren}{\code{CompanyProvider$siren()}}
\item \href{#method-clone}{\code{CompanyProvider$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify">}\href{../../charlatan/html/BaseProvider.html#method-bothify}{\code{charlatan::BaseProvider$bothify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale">}\href{../../charlatan/html/BaseProvider.html#method-check_locale}{\code{charlatan::BaseProvider$check_locale()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify">}\href{../../charlatan/html/BaseProvider.html#method-lexify}{\code{charlatan::BaseProvider$lexify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify">}\href{../../charlatan/html/BaseProvider.html#method-numerify}{\code{charlatan::BaseProvider$numerify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit">}\href{../../charlatan/html/BaseProvider.html#method-random_digit}{\code{charlatan::BaseProvider$random_digit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero}{\code{charlatan::BaseProvider$random_digit_not_zero()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero_or_empty}{\code{charlatan::BaseProvider$random_digit_not_zero_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_or_empty}{\code{charlatan::BaseProvider$random_digit_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element">}\href{../../charlatan/html/BaseProvider.html#method-random_element}{\code{charlatan::BaseProvider$random_element()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob">}\href{../../charlatan/html/BaseProvider.html#method-random_element_prob}{\code{charlatan::BaseProvider$random_element_prob()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int">}\href{../../charlatan/html/BaseProvider.html#method-random_int}{\code{charlatan::BaseProvider$random_int()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter">}\href{../../charlatan/html/BaseProvider.html#method-random_letter}{\code{charlatan::BaseProvider$random_letter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements">}\href{../../charlatan/html/BaseProvider.html#method-randomize_nb_elements}{\code{charlatan::BaseProvider$randomize_nb_elements()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-allowed_locales"></a>}}
\subsection{Method \code{allowed_locales()}}{
fetch the allowed locales for this provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$allowed_locales()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{CompanyProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$new(locale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{(character) the locale to use. See
\verb{$allowed_locales()} for locales supported (default: en_US)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CompanyProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-company"></a>}}
\subsection{Method \code{company()}}{
a company name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$company()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-company_prefix"></a>}}
\subsection{Method \code{company_prefix()}}{
a company prefix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$company_prefix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-company_suffix"></a>}}
\subsection{Method \code{company_suffix()}}{
a company suffix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$company_suffix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-catch_phrase"></a>}}
\subsection{Method \code{catch_phrase()}}{
a catch phrase
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$catch_phrase()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bs"></a>}}
\subsection{Method \code{bs()}}{
BS words
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$bs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-siren"></a>}}
\subsection{Method \code{siren()}}{
a siren
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$siren()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CompanyProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
