% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{generate_ratings}
\alias{generate_ratings}
\title{Generate ratings for a single stim using LLM}
\usage{
generate_ratings(
  model = "gpt-3.5-turbo",
  stim = "kick the bucket",
  prompt = "...",
  question = "...",
  top_p = 1,
  temp = 0,
  n_iterations = 30,
  api_key = "",
  debug = FALSE
)
}
\arguments{
\item{model}{A character string specifying the LLM model to use. Use "deepseek-chat" to call the DeepSeek API.}

\item{stim}{A character string representing the stim (e.g., an idiom).}

\item{prompt}{A character string providing context or an identity for LLM (e.g., "You are a native English speaker.").}

\item{question}{A character string that provides instructions for LLM.}

\item{top_p}{A numeric value limiting token selection to a probability mass.}

\item{temp}{A numeric value specifying the temperature for the API call.}

\item{n_iterations}{An integer indicating the number of times to query LLM for the stim.}

\item{api_key}{Your OpenAI API key.}

\item{debug}{Logical, whether to run in debug mode. Defaults to FALSE.}
}
\value{
A data frame containing the stim, rating, and iteration number for each API call.
}
\description{
This function generates ratings for a given stimulus using a Large Language Model (LLM).
It supports both OpenAI and DeepSeek APIs. When the model parameter is set to "deepseek-chat",
the DeepSeek API endpoint will be used.
}
\examples{
\dontrun{
  generate_ratings(model = "gpt-3.5-turbo",
                   stim = "kick the bucket",
                   prompt = "You are a native English speaker.",
                   question = "Please rate the following stim:",
                   top_p = 1,
                   temp = 0,
                   n_iterations = 30,
                   api_key = "your_api_key",
                   debug = TRUE)
}
}
