#' ChatGPT: Optimize Code
#'
#' @param code The code to be optimized by ChatGPT.
#'
#' @examples
#' \dontrun{
#' cat(optimize_code("i <- 10\nwhile (i > 0) {\n  i <- i - 1\n  print(i)\n}"))
#' }
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
optimize_code <- function(code) {
  prompt <- paste0('Optimize the following R code: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
