% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_source.R
\name{check_source}
\alias{check_source}
\title{Check R-scripts, folders or R-code strings for globals and imports}
\usage{
check_source(file, text, dir, include_compiled = FALSE, skip_globals = NULL)
}
\arguments{
\item{file}{character path to R-script to analyze, can be either a file on the local filesystem or a
remote file location (e.g. a server or the web).}

\item{text}{character R-code string to analyze.}

\item{dir}{character path to folder with R-scripts to analyze.}

\item{include_compiled}{logical value indicating if compiled functions called with \code{\link{.Call}},
\code{\link{.C}}, \code{\link{.External}}, \code{\link{.Fortran}} should be included as global variables.}

\item{skip_globals}{optional character vector of names to skip/exclude as (unrecognized) global variables.}
}
\value{
list S3-object of class \code{"checkglobals"} with three components:
\itemize{
\item \code{globals}, list of class \code{"checkglobalsg"}
\item \code{imports}, list of class \code{"checkglobalsi"}
\item \code{missing_packages}, character vector with missing packages
}
for programmatic use, cast the returned S3-object with \code{\link{as.data.frame}}, \code{\link{as.matrix}},
\code{\link{as.character}} or \code{\link[checkglobals]{as_vector}}.
}
\description{
Approximately detect global and imported functions or variables from R-scripts, folders or
R-code strings by static code analysis. For inspection of individual R-scripts use the `file` argument,
for R-code strings use the `text` argument, and for folders containing R-scripts use the `dir` argument.
This function does not require executing the code under inspection.
}
\examples{
## local R-script
check_source(
  file = system.file(
    "unit_tests", "pkg", "testpkg", "R", "functions1.R",
    package = "checkglobals"
  )
)

## local R-folder
check_source(
  dir = system.file(
    "unit_tests", "pkg", "testpkg", "R",
    package = "checkglobals"
  )
)

## R-code string
check_source(text = "cc <- function(m) stats::coef(m)")

## R-script from remote location
\donttest{
  check_source(
    file = "https://raw.githubusercontent.com/rstudio/shiny-examples/main/004-mpg/app.R"
  )
}
}
\seealso{
\code{\link{checkglobals}}, \code{\link{check_pkg}}
}
