% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkFlag}
\alias{assertFlag}
\alias{checkFlag}
\alias{testFlag}
\title{Check if an argument is a flag}
\usage{
checkFlag(x, na.ok = FALSE)

assertFlag(x, na.ok = FALSE, .var.name)

testFlag(x, na.ok = FALSE)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertFlag} throws an error message,
 \code{testFlag} returns \code{FALSE} and \code{checkFlag} returns
 a string with the error message.
}
\description{
A flag a a single logical value.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testFlag(TRUE)
testFlag(1)
}
\seealso{
Other scalars: \code{\link{assertCount}},
  \code{\link{checkCount}}, \code{\link{testCount}};
  \code{\link{assertInt}}, \code{\link{checkInt}},
  \code{\link{testInt}}; \code{\link{assertNumber}},
  \code{\link{checkNumber}}, \code{\link{testNumber}};
  \code{\link{assertScalarNA}},
  \code{\link{checkScalarNA}}, \code{\link{testScalarNA}};
  \code{\link{assertScalar}}, \code{\link{checkScalar}},
  \code{\link{testScalar}}; \code{\link{assertString}},
  \code{\link{checkString}}, \code{\link{testString}}
}

