% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInt.r
\name{checkInt}
\alias{assertInt}
\alias{assert_int}
\alias{checkInt}
\alias{expect_int}
\alias{testInt}
\alias{test_int}
\title{Check if an argument is a single integerish value}
\usage{
checkInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps))

assertInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), add = NULL, .var.name)

assert_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), add = NULL, .var.name)

testInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps))

test_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps))

expect_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertInt}/\code{assert_int}
 throws an error message, \code{testInt}/\code{test_int}
 returns \code{FALSE},
 and \code{checkInt} returns a string with the error message.
 The function \code{expect_int} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single integerish value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testInt(1)
testInt(-1, lower = 0)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkNumber}},
  \code{\link{checkScalarNA}}, \code{\link{checkScalar}},
  \code{\link{checkString}}
}

