% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFunction.R
\name{checkFunction}
\alias{assertFunction}
\alias{assert_function}
\alias{checkFunction}
\alias{check_function}
\alias{expect_function}
\alias{testFunction}
\alias{test_function}
\title{Check if an argument is a function}
\usage{
checkFunction(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE)

check_function(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE)

assertFunction(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE, .var.name = vname(x), add = NULL)

assert_function(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE, .var.name = vname(x), add = NULL)

testFunction(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE)

test_function(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE)

expect_function(x, args = NULL, ordered = FALSE, nargs = NULL,
  null.ok = FALSE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{args}{[\code{character}]\cr
Expected formal arguments. Checks that a function has no arguments if
set to \code{character(0)}.
Default is \code{NULL} (no check).}

\item{ordered}{[\code{logical(1)}]\cr
Flag whether the arguments provided in \code{args} must be the first
\code{length(args)} arguments of the function in the specified order.
Default is \code{FALSE}.}

\item{nargs}{[\code{integer(1)}]\cr
Required number of arguments, without \code{...}.
Default is \code{NULL} (no check).}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertFunction}/\code{assert_function} return 
 \code{x} invisibly, whereas
 \code{checkFunction}/\code{check_function} and 
 \code{testFunction}/\code{test_function} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertFunction}/\code{assert_function}
 throws an error message, 
 \code{testFunction}/\code{test_function}
 returns \code{FALSE},
 and \code{checkFunction} returns a string with the error message.
 The function \code{expect_function} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a function
}
\examples{
testFunction(mean)
testFunction(mean, args = "x")
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDate}}, \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNull}}, \code{\link{checkNumeric}},
  \code{\link{checkVector}}
}

