% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNames.R
\name{checkNames}
\alias{checkNames}
\alias{check_names}
\alias{assertNames}
\alias{assert_names}
\alias{testNames}
\alias{test_names}
\alias{expect_names}
\title{Check names to comply to specific rules}
\usage{
checkNames(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL)

check_names(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL)

assertNames(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL, .var.name = vname(x), add = NULL)

assert_names(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL, .var.name = vname(x), add = NULL)

testNames(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL)

test_names(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL)

expect_names(x, type = "named", permutation.of = NULL, subset.of = NULL,
  identical.to = NULL, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[\code{character} || \code{NULL}]\cr
Names to check using rules defined via \code{type}.}

\item{type}{[character(1)]\cr
Type of formal check(s) to perform on the names.
\dQuote{unnamed} checks \code{x} to be \code{NULL}.
\dQuote{named} (default) checks \code{x} for regular names which excludes names to be \code{NA} or empty (\code{""}).
\dQuote{unique} additionally tests for non-duplicated names.
\dQuote{strict} checks for unique names which comply to R's variable name restrictions.
Note that for zero-length \code{x} all these name checks evaluate to \code{TRUE}.}

\item{permutation.of}{[\code{character}]\cr
Names provided in \code{x} must be a permutation of the set \code{permutation.of}.
Duplicated names in \code{permutation.of} are stripped out and duplicated names in \code{x}
thus lead to a failed check.
Use this argument instead of \code{identical.to} if the order of the names is not relevant.}

\item{subset.of}{[\code{character}]\cr
Names provided in \code{x} must be subset of the set \code{subset.of}.
Use this argument if duplicated names are okay.}

\item{identical.to}{[\code{character}]\cr
Names provided in \code{x} must be identical to the vector \code{identical.to}.
Use this argument instead of \code{permutation.of} if the order of the names is relevant.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertNamed}/\code{assert_named} return 
 \code{x} invisibly, whereas
 \code{checkNamed}/\code{check_named} and 
 \code{testNamed}/\code{test_named} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertNamed}/\code{assert_named}
 throws an error message, 
 \code{testNamed}/\code{test_named}
 returns \code{FALSE},
 and \code{checkNamed} returns a string with the error message.
 The function \code{expect_named} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Similar to \code{\link{checkNamed}} but you can pass the names directly.
}
\examples{
x = 1:3
testNames(x, "unnamed")
names(x) = letters[1:3]
testNames(x, "unique")

cn = c("Species", "Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")
assertNames(names(iris), permutation.of = cn)
}
\seealso{
Other attributes: \code{\link{checkClass}},
  \code{\link{checkNamed}}
}
