% Generated by roxygen2 (4.0.2): do not edit by hand
\name{checkpoint}
\alias{checkpoint}
\title{Configures R session to use packages as they existed on CRAN at time of snapshot.}
\usage{
checkpoint(snapshotDate, project = getwd(), verbose = TRUE)
}
\arguments{
\item{snapshotDate}{Date of snapshot to use in \code{YYYY-MM-DD} format,e.g. \code{"2014-09-17"}.  Specify a date on or after \code{"2014-09-17"}.  MRAN takes one snapshot per day.}

\item{project}{A project path.  This is the path to the root of the project that references the packages to be installed from the MRAN snapshot for the date specified for \code{snapshotDate}.  Defaults to current working directory using \code{\link{getwd}()}.}

\item{verbose}{If TRUE, displays progress messages.}
}
\value{
NULL.  See the \code{Details} section for side effects.
}
\description{
Together, the checkpoint package and the checkpoint server act as a CRAN time machine.  The \code{checkpoint()} function installs the packages referenced in the specified project to a local library exactly as they existed at the specified point in time.  Only those packages are available to your session, thereby avoiding any package updates that came later and may have altered your results.  In this way, anyone using the checkpoint \code{checkpoint()} function can ensure the reproducibility of your scripts or projects at any time.
}
\section{Details}{


\code{checkpoint()} creates a local library into which it installs a copy of the packages required by your project as they existed on CRAN on the specified snapshot date.  Your R session is updated to use only these packages.

To automatically determine all packages used in your project, the function scans all R code (\code{.R}, \code{.Rmd}, and \code{.Rpres} files) for \code{library()} and \code{requires()} statements.

Specifically, the function will:

\itemize{
\item{Create a new local snapshot library to install packages.  This library folder is at \code{~/.checkpoint}}
\item{Update the options for your CRAN mirror and point to an MRAN snapshot using \code{options(repos)}}
\item{Scan your project folder for all required packages and install them from the snapshot using \code{\link[utils]{install.packages}}}
}
}

\section{Resetting the checkpoint}{

To reset the checkpoint, simply restart your R session.
}
\examples{
\dontrun{

# Create temporary project and set working directory

example_project <- paste0("~/checkpoint_example_project_", Sys.Date())

dir.create(example_project, recursive = TRUE)
oldwd <- setwd(example_project)


# Write dummy code file to project

cat("library(MASS)", "library(foreach)",
    sep="\\n",
    file="checkpoint_example_code.R")


# Create a checkpoint by specifying a snapshot date

library(checkpoint)
checkpoint("2014-09-17")

# Check that CRAN mirror is set to MRAN snapshot
getOption("repos")

# Check that library path is set to ~/.checkpoint
.libPaths()

# Check which packages are installed in checkpoint library
installed.packages()

# cleanup
unlink(example_project, recursive = TRUE)
setwd(oldwd)

}

}

