% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncol.R
\name{check_ncol}
\alias{check_ncol}
\title{Check Number of Columns}
\usage{
check_ncol(x, ncol = c(1L, 2147483647L), x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The data to check.}

\item{ncol}{A count of the number of columns or a count range of the minimum and maximum number of columns.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Check Number of Columns
}
\examples{
check_ncol(data.frame(x = 1), error = FALSE)
check_ncol(data.frame(x = 1:2), ncol = 1, error = FALSE)
}
