% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dttm.R
\name{check_dttm}
\alias{check_dttm}
\alias{check_datetime}
\title{Check Date Time}
\usage{
check_dttm(x, coerce = FALSE, tzone = "UTC", x_name = substitute(x),
  error = TRUE)

check_datetime(x, coerce = FALSE, tzone = "", x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a date to a dttm (using the time zone tzone) and remove names.}

\item{tzone}{A string of the time zone where "" is the current time zone.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a datetime (non-missing unnamed POSIXct scalar).
}
\examples{
check_dttm(Sys.Date(), error = FALSE)
check_dttm(Sys.time(), error = FALSE)
}
\seealso{
\code{\link{check_scalar}}
}
