% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector.R
\name{check_vector}
\alias{check_vector}
\title{Check Atomic Vector}
\usage{
check_vector(x, values = NULL, length = NA, unique = FALSE,
  sorted = FALSE, named = NA, attributes = named, names = TRUE,
  class = TRUE, only = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{values}{NULL or a vector specifying the values.}

\item{length}{A flag indicating whether x should have elements (versus no elements) or a missing value indicating no requirements or a count or count range of the number of elements or a count vector of the permitted number of elements.}

\item{unique}{A flag indicating whether the values must be unique.}

\item{sorted}{A flag indicating whether the vector must be sorted.}

\item{named}{A flag indicating whether the vector must be named or unnamed or NA if it doesn't matter.}

\item{attributes}{A flag indicating whether the vector must or must not have attributes or NA if it doesn't matter.}

\item{names}{A flag specifying whether names should be considered an attribute.}

\item{class}{A flag specifying whether class should be considered an attribute.}

\item{only}{A flag indicating whether only the actual values are permitted.
It only affects values with two or less non-missing elements.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Check Atomic Vector
}
\examples{
check_vector(2:1, length = 3, sorted = TRUE, named = TRUE, error = FALSE)
check_vector(c("one", "two", "four"), values = c("one", "two", "two"), error = FALSE)
}
