% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FOMT.R
\name{par_est_FOMT}
\alias{par_est_FOMT}
\title{First-Order Multi-Target parameter starting values}
\usage{
par_est_FOMT(x, y = NULL)
}
\arguments{
\item{x}{A data-frame with time and concentration in the first and second
columns,respectively. Alternatively, it could be an array of time and y an
array of concentrations.}

\item{y}{Optional, an array of concentrations. To be inserted only if x is an
array.}
}
\value{
The function returns an array with the suggested initial values of
parameters.
}
\description{
\code{par_est_FOMT} estimates the starting values of the parameters of the
first-order multi-target model from a data-set.
}
\examples{
t <- seq(0, 30, by = 6)
k <- 0.3
n <- 40
set.seed(100)
y <- FOMTm(t, k, n) * (1 + rnorm(length(t), 0, 0.05))

nlsFOMT <- nls(y ~ FOMTm(t, k, n),
  data = list(y = y, t = t),
  start = par_est_FOMT(t, y)
)
summary(nlsFOMT)
}
\seealso{
\code{\link[=FOMT]{FOMT()}}, \code{\link[=FOMTm]{FOMTm()}}
}
