% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbt01.R
\name{cfbt01_lyt}
\alias{cfbt01_lyt}
\title{\code{cfbt01} Layout}
\usage{
cfbt01_lyt(
  arm_var,
  lbl_overall,
  lbl_avisit,
  lbl_param,
  summaryvars,
  summaryvars_lbls,
  row_split_var,
  row_split_lbl,
  visitvar,
  precision,
  page_var,
  .stats,
  skip,
  ...
)
}
\arguments{
\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{lbl_avisit}{(\code{string}) label of the \code{visitvar} variable.}

\item{lbl_param}{(\code{string}) label of the \code{PARAM} variable.}

\item{summaryvars}{(\code{character}) the variables to be analyzed. For this table, \code{AVAL} and \code{CHG} by default.}

\item{summaryvars_lbls}{(\code{character}) the label of the variables to be analyzed.}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{row_split_lbl}{(\code{character}) label of further row splits.}

\item{visitvar}{(\code{string}) typically one of \code{"AVISIT"} or user-defined visit incorporating \code{"ATPT"}.}

\item{precision}{(named \code{list} of \code{integer}) where names are values found in the \code{PARAMCD} column and the values
indicate the number of digits in statistics. If \code{default} is set, and parameter precision not specified,
the value for \code{default} will be used. If \code{default} is not set, the default precision is 2.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{.stats}{(\code{character}) statistics names, see \code{tern::analyze_vars()}.}

\item{skip}{Named (\code{list}) of visit values that need to be inhibited.}

\item{...}{not used.}
}
\value{
a \code{PreDataTableLayouts} object.
}
\description{
\code{cfbt01} Layout
}
\keyword{internal}
