% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet01_aesi.R
\docType{data}
\name{aet01_aesi_main}
\alias{aet01_aesi_main}
\alias{aet01_aesi_pre}
\alias{aet01_aesi_post}
\alias{aet01_aesi}
\title{\code{AET01_AESI} Table 1 (Default) Adverse Event of Special Interest Summary Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
aet01_aesi_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  aesi_vars = NULL,
  grade_groups = NULL,
  ...
)

aet01_aesi_pre(adam_db, ...)

aet01_aesi_post(tlg, prune_0 = FALSE, ...)

aet01_aesi
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{aesi_vars}{(\code{character}) the \code{AESI} variables to be included in the summary. Defaults to \code{NA}.}

\item{grade_groups}{(\code{list}) the grade groups to be displayed.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
\code{AET01_AESI} Table 1 (Default) Adverse Event of Special Interest Summary Table.
}
\details{
\itemize{
\item Does not remove rows with zero counts by default.
}
}
\section{Functions}{
\itemize{
\item \code{aet01_aesi_main()}: Main TLG function

\item \code{aet01_aesi_pre()}: Preprocessing

\item \code{aet01_aesi_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adae} table with columns \code{"AEOUT"}, \code{"AEACN"}, \code{"AECONTRT"}, \code{"AESER"},
\code{"AREL"}, and the column specified by \code{arm_var}.
\item \code{aesi_vars} may contain any/all of the following variables to display: \code{"ALLRESWD"}, \code{"ALLRESDSM"},
\code{"ALLRESCONTRT"}, \code{"NOTRESWD"}, \code{"NOTRESDSM"}, \code{"NOTRESCONTRT"}, \code{"SERWD"}, \code{"SERDSM"}, \code{"SERCONTRT"},
\code{"RELWD"}, \code{"RELDSM"}, \code{"RELCONTRT"}, \code{"RELSER"}.
\item \code{aesi_vars} variable prefixes are defined as follows:
\itemize{
\item \code{"ALLRES"} = "all non-fatal adverse events resolved"
\item \code{"NOTRES"} = "at least one unresolved or ongoing non-fatal adverse event"
\item \code{"SER"} = "serious adverse event"
\item \code{"REL"} = "related adverse event"
}
\item \code{aesi_vars} variable suffixes are defined as follows:
\itemize{
\item \code{"WD"} = "patients with study drug withdrawn"
\item \code{"DSM"} = "patients with dose modified/interrupted"
\item \code{"CONTRT"} = "patients with treatment received"
}
\item Several \code{aesi_vars} can be added to the table at once:
\itemize{
\item \code{aesi_vars = "ALL"} will include all possible \code{aesi_vars}.
\item Including \code{"ALL_XXX"} in \code{aesi_vars} where \code{XXX} is one of the prefixes listed above will include all
\code{aesi_vars} with that prefix.
}
}
}
\examples{
run(aet01_aesi, syn_data)
}
\keyword{datasets}
