# vst01 functions with default argument value return expected result with test data

    Code
      cat(export_as_txt(res, lpp = 200))
    Output
      
      Parameter: Diastolic Blood Pressure
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                47.754 (6.827)        NE (NE)       52.552 (8.234)        NE (NE)    
          Median                       47.973              NE              54.453              NE       
          Min - Max                 32.28 - 58.80        NE - NE        34.09 - 62.76        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                48.453 (8.983)                      53.244 (6.030)                   
          Median                       47.331                              53.581                       
          Min - Max                 34.23 - 64.64                       43.38 - 62.65                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.591 (8.543)    1.138 (11.242)    51.644 (6.469)    -1.601 (8.747) 
          Median                       46.979            -1.626            53.081             1.291     
          Min - Max                 37.02 - 62.15    -13.13 - 19.07     38.36 - 63.15    -21.18 - 11.45 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                49.903 (5.791)     1.450 (8.476)    48.989 (6.919)    -4.255 (8.332) 
          Median                       50.599             0.692            49.800            -3.891     
          Min - Max                 38.79 - 59.12    -15.80 - 19.03     31.52 - 60.32    -22.06 - 10.10 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                49.640 (10.443)   1.187 (13.731)    46.794 (6.770)    -6.451 (8.753) 
          Median                       50.458            -0.109            46.497            -5.754     
          Min - Max                 29.07 - 74.89    -19.15 - 30.66     37.12 - 57.89     -21.22 - 9.01 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.360 (8.909)    2.907 (12.296)    48.587 (7.780)    -4.657 (10.369)
          Median                       49.267             1.004            48.954            -6.717     
          Min - Max                 35.24 - 69.30    -15.37 - 24.76     35.34 - 62.63    -22.84 - 19.25 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.289 (7.415)    -1.164 (11.549)   49.156 (8.281)    -4.088 (11.037)
          Median                       46.319            -1.354            49.620            -4.528     
          Min - Max                 35.42 - 65.64    -19.45 - 18.94     37.79 - 65.06    -21.75 - 15.14 
      \s\n
      Parameter: Diastolic Blood Pressure
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                52.587 (5.051)        NE (NE)    
          Median                       53.344              NE       
          Min - Max                 43.31 - 60.87        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                51.260 (7.901)                   
          Median                       51.140                       
          Min - Max                 36.42 - 64.62                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                50.330 (7.611)    -0.929 (10.007)
          Median                       51.223            -0.990     
          Min - Max                 38.02 - 61.47    -22.06 - 16.72 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                47.709 (6.784)    -3.551 (10.892)
          Median                       48.715            -4.062     
          Min - Max                 35.38 - 56.99    -29.24 - 18.62 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                47.834 (5.424)    -3.425 (8.685) 
          Median                       49.359            -6.430     
          Min - Max                 39.40 - 56.17    -15.16 - 13.06 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                53.335 (7.367)     2.075 (8.753) 
          Median                       53.022             3.186     
          Min - Max                 37.51 - 63.01    -13.58 - 16.60 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                48.127 (6.561)    -3.133 (7.931) 
          Median                       47.550            -1.866     
          Min - Max                 38.76 - 65.42    -17.79 - 11.64 
      \s\n
      Parameter: Pulse Rate
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                48.421 (10.537)       NE (NE)       47.202 (6.270)        NE (NE)    
          Median                       47.067              NE              46.873              NE       
          Min - Max                 25.94 - 64.18        NE - NE        35.92 - 56.82        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                51.695 (10.441)                     51.005 (6.432)                   
          Median                       52.073                              51.509                       
          Min - Max                 33.17 - 72.90                       37.35 - 63.96                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                50.224 (8.737)    -1.471 (15.335)   48.178 (6.149)    -2.827 (10.025)
          Median                       49.298            -7.210            47.020            -4.489     
          Min - Max                 34.56 - 67.04    -26.42 - 29.59     38.26 - 60.51    -20.50 - 14.05 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.711 (7.437)    -3.984 (13.439)   49.555 (6.189)    -1.450 (7.745) 
          Median                       48.109            -4.204            48.386            -0.174     
          Min - Max                 34.03 - 59.96    -27.75 - 26.40     38.49 - 61.59    -18.53 - 11.78 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.255 (5.201)    -1.441 (10.712)   51.315 (7.200)     0.310 (8.513) 
          Median                       48.553            -1.996            53.776            -0.367     
          Min - Max                 40.49 - 57.42    -20.85 - 16.60     37.07 - 62.80    -17.61 - 14.58 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                48.596 (7.922)    -3.099 (13.626)   52.969 (9.476)    1.964 (10.703) 
          Median                       48.877            -4.197            50.584             1.306     
          Min - Max                 34.98 - 61.49    -26.31 - 26.80     42.50 - 79.82    -16.15 - 28.32 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.827 (7.675)    -3.869 (14.122)   49.765 (5.632)    -1.240 (7.723) 
          Median                       47.635            -2.208            49.034            -1.832     
          Min - Max                 31.57 - 64.49    -41.33 - 12.68     41.05 - 59.80    -12.11 - 13.05 
      \s\n
      Parameter: Pulse Rate
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                51.266 (9.456)        NE (NE)    
          Median                       49.479              NE       
          Min - Max                 33.73 - 65.17        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                48.881 (9.415)                   
          Median                       49.324                       
          Min - Max                 32.64 - 65.79                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                51.448 (6.492)    2.567 (11.419) 
          Median                       52.422             2.593     
          Min - Max                 42.57 - 63.17    -17.54 - 26.11 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                48.235 (6.317)    -0.647 (9.609) 
          Median                       49.716             0.391     
          Min - Max                 36.37 - 60.56    -21.63 - 12.40 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                47.217 (6.150)    -1.664 (9.545) 
          Median                       46.013            -3.589     
          Min - Max                 39.84 - 64.86    -14.33 - 16.57 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                49.122 (8.170)    0.241 (12.832) 
          Median                       49.955            -0.050     
          Min - Max                 31.41 - 64.70    -23.60 - 21.22 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                47.293 (5.700)    -1.588 (12.173)
          Median                       47.745            -3.616     
          Min - Max                 35.69 - 54.78    -18.57 - 22.14 
      \s\n
      Parameter: Respiratory Rate
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                48.906 (12.292)       NE (NE)       50.950 (7.338)        NE (NE)    
          Median                       46.592              NE              50.648              NE       
          Min - Max                 30.61 - 74.45        NE - NE        36.19 - 66.05        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                50.589 (6.855)                      55.218 (8.434)                   
          Median                       49.584                              55.756                       
          Min - Max                 41.30 - 63.39                       40.73 - 70.38                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                50.022 (7.637)    -0.567 (11.296)   50.017 (9.991)    -5.201 (12.594)
          Median                       49.151             1.204            53.477            -6.762     
          Min - Max                 36.85 - 66.01    -22.69 - 16.19     25.05 - 63.62    -29.13 - 16.83 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.732 (3.584)     1.143 (7.043)    48.696 (8.830)    -6.522 (12.219)
          Median                       52.033             1.546            46.642            -6.191     
          Min - Max                 46.19 - 58.13    -14.30 - 16.83     36.65 - 64.49    -29.01 - 22.21 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.966 (8.104)     0.378 (9.797)    46.562 (5.712)    -8.656 (11.231)
          Median                       50.124            -0.901            47.929            -10.648    
          Min - Max                 40.07 - 70.78    -21.61 - 26.14     36.02 - 57.23    -22.70 - 14.95 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                49.715 (6.434)    -0.874 (8.867)    49.363 (5.975)    -5.855 (11.306)
          Median                       48.818            -1.002            48.943            -8.507     
          Min - Max                 41.24 - 60.98    -19.43 - 18.96     39.21 - 65.31    -20.95 - 16.77 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                52.335 (8.196)     1.746 (9.180)    53.383 (8.955)    -1.835 (14.002)
          Median                       50.831             4.027            52.460            -0.259     
          Min - Max                 40.08 - 67.28    -15.75 - 15.04     39.81 - 65.85    -22.68 - 23.57 
      \s\n
      Parameter: Respiratory Rate
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                51.031 (9.490)        NE (NE)    
          Median                       52.351              NE       
          Min - Max                 35.39 - 65.84        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                47.686 (8.604)                   
          Median                       46.637                       
          Min - Max                 31.47 - 60.42                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                50.808 (7.789)    3.121 (10.371) 
          Median                       51.366             2.361     
          Min - Max                 37.46 - 64.04     -9.17 - 25.16 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                48.654 (7.717)    0.968 (11.831) 
          Median                       48.473             0.296     
          Min - Max                 32.16 - 61.09    -16.53 - 26.98 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                48.805 (5.940)     1.119 (9.224) 
          Median                       47.039             0.862     
          Min - Max                 40.16 - 60.93    -14.86 - 18.86 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                47.228 (9.076)    -0.458 (11.481)
          Median                       45.850             0.356     
          Min - Max                 31.87 - 62.42    -27.64 - 15.31 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                47.223 (8.014)    -0.463 (12.067)
          Median                       47.917            -5.497     
          Min - Max                 37.20 - 64.37    -16.91 - 22.32 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                50.524 (9.964)        NE (NE)       48.742 (9.375)        NE (NE)    
          Median                       48.432              NE              49.563              NE       
          Min - Max                 37.54 - 70.85        NE - NE        33.15 - 61.19        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                48.917 (8.422)                      52.206 (7.663)                   
          Median                       47.976                              50.399                       
          Min - Max                 35.92 - 63.83                       36.85 - 69.87                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.034 (7.281)    0.118 (12.328)    49.648 (7.885)    -2.558 (10.315)
          Median                       45.853            -2.350            49.750            -4.912     
          Min - Max                 38.46 - 62.80    -18.78 - 19.87     37.12 - 62.87    -17.67 - 16.38 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.697 (10.111)   1.781 (11.712)    48.917 (6.464)    -3.289 (12.641)
          Median                       48.793             2.483            48.304            -1.084     
          Min - Max                 33.60 - 64.41    -20.66 - 23.99     32.77 - 57.63    -37.10 - 15.27 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.129 (8.417)    -1.787 (10.523)   44.842 (9.839)    -7.365 (12.156)
          Median                       47.910            -1.677            44.495            -4.628     
          Min - Max                 33.85 - 59.67    -19.31 - 14.54     15.58 - 58.38    -35.56 - 11.49 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.984 (9.702)    2.068 (12.168)    50.001 (10.412)   -2.206 (11.420)
          Median                       51.783             4.255            51.045             1.095     
          Min - Max                 38.70 - 66.08    -15.94 - 20.88     33.06 - 67.92    -21.01 - 19.90 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                48.748 (9.820)    -0.169 (11.595)   47.553 (7.967)    -4.653 (11.661)
          Median                       47.844             0.827            46.869            -1.284     
          Min - Max                 29.55 - 69.66    -18.39 - 18.76     35.50 - 63.63    -27.59 - 13.23 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                53.448 (7.713)        NE (NE)    
          Median                       55.800              NE       
          Min - Max                 35.15 - 65.39        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                44.329 (6.177)                   
          Median                       43.480                       
          Min - Max                 35.88 - 55.61                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                49.845 (10.051)    5.516 (8.410) 
          Median                       50.426             7.279     
          Min - Max                 32.64 - 63.18    -11.55 - 21.18 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                44.922 (7.731)     0.593 (8.516) 
          Median                       46.824             2.724     
          Min - Max                 29.39 - 61.47    -18.72 - 13.40 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                52.240 (6.714)     7.911 (9.955) 
          Median                       52.734             7.321     
          Min - Max                 40.87 - 64.82     -9.47 - 22.94 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                51.404 (8.276)    7.075 (10.011) 
          Median                       55.334             6.775     
          Min - Max                 32.28 - 60.16    -15.84 - 24.23 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                51.113 (7.249)     6.784 (9.493) 
          Median                       51.106             8.107     
          Min - Max                 34.27 - 60.01    -14.02 - 21.11 
      \s\n
      Parameter: Temperature
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                48.824 (9.858)        NE (NE)       51.048 (5.453)        NE (NE)    
          Median                       51.818              NE              52.905              NE       
          Min - Max                 31.70 - 66.40        NE - NE        39.17 - 57.64        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                51.016 (10.725)                     48.255 (9.140)                   
          Median                       51.035                              48.922                       
          Min - Max                 36.75 - 68.33                       33.76 - 62.88                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.365 (7.405)    -1.651 (16.217)   48.135 (9.314)    -0.120 (11.447)
          Median                       50.234            -0.801            45.868            -2.110     
          Min - Max                 37.95 - 60.08    -27.99 - 21.48     34.08 - 66.90    -16.88 - 19.37 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.345 (6.784)    -0.670 (13.506)   48.563 (4.812)    0.308 (11.073) 
          Median                       50.213            -4.256            48.837             1.798     
          Min - Max                 39.51 - 59.08    -24.74 - 20.15     39.56 - 56.97    -18.33 - 20.77 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.398 (9.776)    -0.618 (13.441)   47.522 (7.917)    -0.733 (13.047)
          Median                       49.682            -0.322            47.870            -4.824     
          Min - Max                 32.92 - 68.65    -19.48 - 24.08     32.73 - 59.16    -18.74 - 21.57 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.072 (7.179)    0.056 (14.414)    52.307 (8.264)    4.053 (12.529) 
          Median                       52.542             1.637            53.306             1.408     
          Min - Max                 37.05 - 66.00    -24.48 - 26.05     37.36 - 63.24    -17.71 - 19.76 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                46.358 (6.767)    -4.658 (14.692)   51.317 (9.459)    3.062 (12.927) 
          Median                       46.812            -4.596            48.036             2.309     
          Min - Max                 34.83 - 58.22    -30.07 - 19.29     40.87 - 77.96    -16.62 - 30.92 
      \s\n
      Parameter: Temperature
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                49.785 (6.899)        NE (NE)    
          Median                       49.860              NE       
          Min - Max                 35.66 - 62.68        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                50.399 (7.546)                   
          Median                       49.322                       
          Min - Max                 36.88 - 64.72                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                51.300 (7.928)    0.901 (11.941) 
          Median                       48.375             0.717     
          Min - Max                 41.95 - 68.46    -22.77 - 19.34 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                52.829 (7.278)    2.430 (12.142) 
          Median                       51.796             4.048     
          Min - Max                 37.79 - 62.44    -18.33 - 23.63 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                54.052 (10.230)   3.653 (11.530) 
          Median                       56.639             7.116     
          Min - Max                 36.16 - 66.68    -17.42 - 23.40 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                51.404 (7.355)    1.005 (11.167) 
          Median                       49.707            -0.284     
          Min - Max                 39.76 - 67.61    -15.02 - 27.76 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                47.230 (6.321)    -3.169 (10.456)
          Median                       48.126            -1.798     
          Min - Max                 37.00 - 57.36    -19.12 - 13.16 
      \s\n
      Parameter: Weight
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                46.864 (6.820)        NE (NE)       51.477 (9.043)        NE (NE)    
          Median                       46.298              NE              49.553              NE       
          Min - Max                 36.38 - 65.18        NE - NE        35.05 - 69.07        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                50.128 (7.228)                      50.190 (6.647)                   
          Median                       48.876                              51.028                       
          Min - Max                 41.87 - 67.60                       35.07 - 60.96                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.754 (4.615)    -0.374 (8.384)    43.940 (8.075)    -6.250 (10.866)
          Median                       51.599            -0.458            43.932            -3.301     
          Min - Max                 38.82 - 55.02    -14.90 - 10.69     32.05 - 58.63    -22.08 - 17.90 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.136 (7.321)    1.007 (10.526)    50.457 (6.967)    0.267 (10.261) 
          Median                       49.297             2.009            51.400             0.175     
          Min - Max                 40.74 - 62.71    -18.30 - 16.74     38.67 - 64.61    -19.35 - 20.03 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.589 (9.787)    -2.539 (14.436)   49.409 (8.233)    -0.781 (11.018)
          Median                       46.684            -1.599            49.126             0.823     
          Min - Max                 31.68 - 60.78    -29.72 - 17.50     34.70 - 59.13    -15.90 - 15.60 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.868 (5.565)     0.740 (8.978)    48.702 (9.926)    -1.488 (12.483)
          Median                       50.915            -0.812            47.733             0.724     
          Min - Max                 43.52 - 63.79    -17.46 - 14.78     29.34 - 63.05    -24.46 - 17.60 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                46.872 (6.924)    -3.256 (8.679)    52.382 (12.113)   2.192 (10.944) 
          Median                       47.348            -3.718            50.480             0.039     
          Min - Max                 32.92 - 55.85     -18.84 - 8.81     34.97 - 76.63    -16.57 - 17.23 
      \s\n
      Parameter: Weight
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                47.802 (9.718)        NE (NE)    
          Median                       44.999              NE       
          Min - Max                 33.02 - 62.96        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                48.882 (6.494)                   
          Median                       49.514                       
          Min - Max                 36.44 - 60.34                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                52.260 (8.638)     3.378 (9.764) 
          Median                       54.801             1.232     
          Min - Max                 36.10 - 63.51    -11.46 - 26.60 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                50.732 (10.876)   1.850 (13.271) 
          Median                       49.559             3.711     
          Min - Max                 28.09 - 73.67    -18.04 - 26.59 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                48.880 (7.877)    -0.002 (10.537)
          Median                       51.352             3.713     
          Min - Max                 27.81 - 63.18    -21.81 - 14.87 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                51.459 (6.985)     2.577 (9.123) 
          Median                       52.038             3.117     
          Min - Max                 40.20 - 63.54     -8.49 - 21.55 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                49.234 (6.227)     0.352 (9.015) 
          Median                       47.723             0.408     
          Min - Max                 39.80 - 58.46    -15.71 - 14.74 

# run vst01 works as expected

    Code
      cat(export_as_txt(res, lpp = 200))
    Output
      
      Parameter: Diastolic Blood Pressure
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                47.754 (6.827)        NE (NE)       52.552 (8.234)        NE (NE)    
          Median                       47.973              NE              54.453              NE       
          Min - Max                 32.28 - 58.80        NE - NE        34.09 - 62.76        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                48.453 (8.983)                      53.244 (6.030)                   
          Median                       47.331                              53.581                       
          Min - Max                 34.23 - 64.64                       43.38 - 62.65                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.591 (8.543)    1.138 (11.242)    51.644 (6.469)    -1.601 (8.747) 
          Median                       46.979            -1.626            53.081             1.291     
          Min - Max                 37.02 - 62.15    -13.13 - 19.07     38.36 - 63.15    -21.18 - 11.45 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                49.903 (5.791)     1.450 (8.476)    48.989 (6.919)    -4.255 (8.332) 
          Median                       50.599             0.692            49.800            -3.891     
          Min - Max                 38.79 - 59.12    -15.80 - 19.03     31.52 - 60.32    -22.06 - 10.10 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                49.640 (10.443)   1.187 (13.731)    46.794 (6.770)    -6.451 (8.753) 
          Median                       50.458            -0.109            46.497            -5.754     
          Min - Max                 29.07 - 74.89    -19.15 - 30.66     37.12 - 57.89     -21.22 - 9.01 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.360 (8.909)    2.907 (12.296)    48.587 (7.780)    -4.657 (10.369)
          Median                       49.267             1.004            48.954            -6.717     
          Min - Max                 35.24 - 69.30    -15.37 - 24.76     35.34 - 62.63    -22.84 - 19.25 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.289 (7.415)    -1.164 (11.549)   49.156 (8.281)    -4.088 (11.037)
          Median                       46.319            -1.354            49.620            -4.528     
          Min - Max                 35.42 - 65.64    -19.45 - 18.94     37.79 - 65.06    -21.75 - 15.14 
      \s\n
      Parameter: Diastolic Blood Pressure
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                52.587 (5.051)        NE (NE)    
          Median                       53.344              NE       
          Min - Max                 43.31 - 60.87        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                51.260 (7.901)                   
          Median                       51.140                       
          Min - Max                 36.42 - 64.62                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                50.330 (7.611)    -0.929 (10.007)
          Median                       51.223            -0.990     
          Min - Max                 38.02 - 61.47    -22.06 - 16.72 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                47.709 (6.784)    -3.551 (10.892)
          Median                       48.715            -4.062     
          Min - Max                 35.38 - 56.99    -29.24 - 18.62 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                47.834 (5.424)    -3.425 (8.685) 
          Median                       49.359            -6.430     
          Min - Max                 39.40 - 56.17    -15.16 - 13.06 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                53.335 (7.367)     2.075 (8.753) 
          Median                       53.022             3.186     
          Min - Max                 37.51 - 63.01    -13.58 - 16.60 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                48.127 (6.561)    -3.133 (7.931) 
          Median                       47.550            -1.866     
          Min - Max                 38.76 - 65.42    -17.79 - 11.64 
      \s\n
      Parameter: Pulse Rate
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                48.421 (10.537)       NE (NE)       47.202 (6.270)        NE (NE)    
          Median                       47.067              NE              46.873              NE       
          Min - Max                 25.94 - 64.18        NE - NE        35.92 - 56.82        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                51.695 (10.441)                     51.005 (6.432)                   
          Median                       52.073                              51.509                       
          Min - Max                 33.17 - 72.90                       37.35 - 63.96                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                50.224 (8.737)    -1.471 (15.335)   48.178 (6.149)    -2.827 (10.025)
          Median                       49.298            -7.210            47.020            -4.489     
          Min - Max                 34.56 - 67.04    -26.42 - 29.59     38.26 - 60.51    -20.50 - 14.05 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.711 (7.437)    -3.984 (13.439)   49.555 (6.189)    -1.450 (7.745) 
          Median                       48.109            -4.204            48.386            -0.174     
          Min - Max                 34.03 - 59.96    -27.75 - 26.40     38.49 - 61.59    -18.53 - 11.78 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.255 (5.201)    -1.441 (10.712)   51.315 (7.200)     0.310 (8.513) 
          Median                       48.553            -1.996            53.776            -0.367     
          Min - Max                 40.49 - 57.42    -20.85 - 16.60     37.07 - 62.80    -17.61 - 14.58 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                48.596 (7.922)    -3.099 (13.626)   52.969 (9.476)    1.964 (10.703) 
          Median                       48.877            -4.197            50.584             1.306     
          Min - Max                 34.98 - 61.49    -26.31 - 26.80     42.50 - 79.82    -16.15 - 28.32 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.827 (7.675)    -3.869 (14.122)   49.765 (5.632)    -1.240 (7.723) 
          Median                       47.635            -2.208            49.034            -1.832     
          Min - Max                 31.57 - 64.49    -41.33 - 12.68     41.05 - 59.80    -12.11 - 13.05 
      \s\n
      Parameter: Pulse Rate
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                51.266 (9.456)        NE (NE)    
          Median                       49.479              NE       
          Min - Max                 33.73 - 65.17        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                48.881 (9.415)                   
          Median                       49.324                       
          Min - Max                 32.64 - 65.79                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                51.448 (6.492)    2.567 (11.419) 
          Median                       52.422             2.593     
          Min - Max                 42.57 - 63.17    -17.54 - 26.11 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                48.235 (6.317)    -0.647 (9.609) 
          Median                       49.716             0.391     
          Min - Max                 36.37 - 60.56    -21.63 - 12.40 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                47.217 (6.150)    -1.664 (9.545) 
          Median                       46.013            -3.589     
          Min - Max                 39.84 - 64.86    -14.33 - 16.57 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                49.122 (8.170)    0.241 (12.832) 
          Median                       49.955            -0.050     
          Min - Max                 31.41 - 64.70    -23.60 - 21.22 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                47.293 (5.700)    -1.588 (12.173)
          Median                       47.745            -3.616     
          Min - Max                 35.69 - 54.78    -18.57 - 22.14 
      \s\n
      Parameter: Respiratory Rate
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                48.906 (12.292)       NE (NE)       50.950 (7.338)        NE (NE)    
          Median                       46.592              NE              50.648              NE       
          Min - Max                 30.61 - 74.45        NE - NE        36.19 - 66.05        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                50.589 (6.855)                      55.218 (8.434)                   
          Median                       49.584                              55.756                       
          Min - Max                 41.30 - 63.39                       40.73 - 70.38                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                50.022 (7.637)    -0.567 (11.296)   50.017 (9.991)    -5.201 (12.594)
          Median                       49.151             1.204            53.477            -6.762     
          Min - Max                 36.85 - 66.01    -22.69 - 16.19     25.05 - 63.62    -29.13 - 16.83 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.732 (3.584)     1.143 (7.043)    48.696 (8.830)    -6.522 (12.219)
          Median                       52.033             1.546            46.642            -6.191     
          Min - Max                 46.19 - 58.13    -14.30 - 16.83     36.65 - 64.49    -29.01 - 22.21 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.966 (8.104)     0.378 (9.797)    46.562 (5.712)    -8.656 (11.231)
          Median                       50.124            -0.901            47.929            -10.648    
          Min - Max                 40.07 - 70.78    -21.61 - 26.14     36.02 - 57.23    -22.70 - 14.95 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                49.715 (6.434)    -0.874 (8.867)    49.363 (5.975)    -5.855 (11.306)
          Median                       48.818            -1.002            48.943            -8.507     
          Min - Max                 41.24 - 60.98    -19.43 - 18.96     39.21 - 65.31    -20.95 - 16.77 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                52.335 (8.196)     1.746 (9.180)    53.383 (8.955)    -1.835 (14.002)
          Median                       50.831             4.027            52.460            -0.259     
          Min - Max                 40.08 - 67.28    -15.75 - 15.04     39.81 - 65.85    -22.68 - 23.57 
      \s\n
      Parameter: Respiratory Rate
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                51.031 (9.490)        NE (NE)    
          Median                       52.351              NE       
          Min - Max                 35.39 - 65.84        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                47.686 (8.604)                   
          Median                       46.637                       
          Min - Max                 31.47 - 60.42                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                50.808 (7.789)    3.121 (10.371) 
          Median                       51.366             2.361     
          Min - Max                 37.46 - 64.04     -9.17 - 25.16 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                48.654 (7.717)    0.968 (11.831) 
          Median                       48.473             0.296     
          Min - Max                 32.16 - 61.09    -16.53 - 26.98 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                48.805 (5.940)     1.119 (9.224) 
          Median                       47.039             0.862     
          Min - Max                 40.16 - 60.93    -14.86 - 18.86 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                47.228 (9.076)    -0.458 (11.481)
          Median                       45.850             0.356     
          Min - Max                 31.87 - 62.42    -27.64 - 15.31 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                47.223 (8.014)    -0.463 (12.067)
          Median                       47.917            -5.497     
          Min - Max                 37.20 - 64.37    -16.91 - 22.32 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                50.524 (9.964)        NE (NE)       48.742 (9.375)        NE (NE)    
          Median                       48.432              NE              49.563              NE       
          Min - Max                 37.54 - 70.85        NE - NE        33.15 - 61.19        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                48.917 (8.422)                      52.206 (7.663)                   
          Median                       47.976                              50.399                       
          Min - Max                 35.92 - 63.83                       36.85 - 69.87                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.034 (7.281)    0.118 (12.328)    49.648 (7.885)    -2.558 (10.315)
          Median                       45.853            -2.350            49.750            -4.912     
          Min - Max                 38.46 - 62.80    -18.78 - 19.87     37.12 - 62.87    -17.67 - 16.38 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.697 (10.111)   1.781 (11.712)    48.917 (6.464)    -3.289 (12.641)
          Median                       48.793             2.483            48.304            -1.084     
          Min - Max                 33.60 - 64.41    -20.66 - 23.99     32.77 - 57.63    -37.10 - 15.27 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.129 (8.417)    -1.787 (10.523)   44.842 (9.839)    -7.365 (12.156)
          Median                       47.910            -1.677            44.495            -4.628     
          Min - Max                 33.85 - 59.67    -19.31 - 14.54     15.58 - 58.38    -35.56 - 11.49 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.984 (9.702)    2.068 (12.168)    50.001 (10.412)   -2.206 (11.420)
          Median                       51.783             4.255            51.045             1.095     
          Min - Max                 38.70 - 66.08    -15.94 - 20.88     33.06 - 67.92    -21.01 - 19.90 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                48.748 (9.820)    -0.169 (11.595)   47.553 (7.967)    -4.653 (11.661)
          Median                       47.844             0.827            46.869            -1.284     
          Min - Max                 29.55 - 69.66    -18.39 - 18.76     35.50 - 63.63    -27.59 - 13.23 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                53.448 (7.713)        NE (NE)    
          Median                       55.800              NE       
          Min - Max                 35.15 - 65.39        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                44.329 (6.177)                   
          Median                       43.480                       
          Min - Max                 35.88 - 55.61                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                49.845 (10.051)    5.516 (8.410) 
          Median                       50.426             7.279     
          Min - Max                 32.64 - 63.18    -11.55 - 21.18 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                44.922 (7.731)     0.593 (8.516) 
          Median                       46.824             2.724     
          Min - Max                 29.39 - 61.47    -18.72 - 13.40 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                52.240 (6.714)     7.911 (9.955) 
          Median                       52.734             7.321     
          Min - Max                 40.87 - 64.82     -9.47 - 22.94 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                51.404 (8.276)    7.075 (10.011) 
          Median                       55.334             6.775     
          Min - Max                 32.28 - 60.16    -15.84 - 24.23 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                51.113 (7.249)     6.784 (9.493) 
          Median                       51.106             8.107     
          Min - Max                 34.27 - 60.01    -14.02 - 21.11 
      \s\n
      Parameter: Temperature
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                48.824 (9.858)        NE (NE)       51.048 (5.453)        NE (NE)    
          Median                       51.818              NE              52.905              NE       
          Min - Max                 31.70 - 66.40        NE - NE        39.17 - 57.64        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                51.016 (10.725)                     48.255 (9.140)                   
          Median                       51.035                              48.922                       
          Min - Max                 36.75 - 68.33                       33.76 - 62.88                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.365 (7.405)    -1.651 (16.217)   48.135 (9.314)    -0.120 (11.447)
          Median                       50.234            -0.801            45.868            -2.110     
          Min - Max                 37.95 - 60.08    -27.99 - 21.48     34.08 - 66.90    -16.88 - 19.37 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.345 (6.784)    -0.670 (13.506)   48.563 (4.812)    0.308 (11.073) 
          Median                       50.213            -4.256            48.837             1.798     
          Min - Max                 39.51 - 59.08    -24.74 - 20.15     39.56 - 56.97    -18.33 - 20.77 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.398 (9.776)    -0.618 (13.441)   47.522 (7.917)    -0.733 (13.047)
          Median                       49.682            -0.322            47.870            -4.824     
          Min - Max                 32.92 - 68.65    -19.48 - 24.08     32.73 - 59.16    -18.74 - 21.57 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.072 (7.179)    0.056 (14.414)    52.307 (8.264)    4.053 (12.529) 
          Median                       52.542             1.637            53.306             1.408     
          Min - Max                 37.05 - 66.00    -24.48 - 26.05     37.36 - 63.24    -17.71 - 19.76 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                46.358 (6.767)    -4.658 (14.692)   51.317 (9.459)    3.062 (12.927) 
          Median                       46.812            -4.596            48.036             2.309     
          Min - Max                 34.83 - 58.22    -30.07 - 19.29     40.87 - 77.96    -16.62 - 30.92 
      \s\n
      Parameter: Temperature
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                49.785 (6.899)        NE (NE)    
          Median                       49.860              NE       
          Min - Max                 35.66 - 62.68        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                50.399 (7.546)                   
          Median                       49.322                       
          Min - Max                 36.88 - 64.72                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                51.300 (7.928)    0.901 (11.941) 
          Median                       48.375             0.717     
          Min - Max                 41.95 - 68.46    -22.77 - 19.34 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                52.829 (7.278)    2.430 (12.142) 
          Median                       51.796             4.048     
          Min - Max                 37.79 - 62.44    -18.33 - 23.63 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                54.052 (10.230)   3.653 (11.530) 
          Median                       56.639             7.116     
          Min - Max                 36.16 - 66.68    -17.42 - 23.40 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                51.404 (7.355)    1.005 (11.167) 
          Median                       49.707            -0.284     
          Min - Max                 39.76 - 67.61    -15.02 - 27.76 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                47.230 (6.321)    -3.169 (10.456)
          Median                       48.126            -1.798     
          Min - Max                 37.00 - 57.36    -19.12 - 13.16 
      \s\n
      Parameter: Weight
      
        ————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                          B: Placebo            
                                                       Change from                         Change from  
                                   Value at Visit       Baseline       Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)            (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                       
          n                              15                 0                15                 0       
          Mean (SD)                46.864 (6.820)        NE (NE)       51.477 (9.043)        NE (NE)    
          Median                       46.298              NE              49.553              NE       
          Min - Max                 36.38 - 65.18        NE - NE        35.05 - 69.07        NE - NE    
        BASELINE                                                                                        
          n                              15                                  15                         
          Mean (SD)                50.128 (7.228)                      50.190 (6.647)                   
          Median                       48.876                              51.028                       
          Min - Max                 41.87 - 67.60                       35.07 - 60.96                   
        WEEK 1 DAY 8                                                                                    
          n                              15                15                15                15       
          Mean (SD)                49.754 (4.615)    -0.374 (8.384)    43.940 (8.075)    -6.250 (10.866)
          Median                       51.599            -0.458            43.932            -3.301     
          Min - Max                 38.82 - 55.02    -14.90 - 10.69     32.05 - 58.63    -22.08 - 17.90 
        WEEK 2 DAY 15                                                                                   
          n                              15                15                15                15       
          Mean (SD)                51.136 (7.321)    1.007 (10.526)    50.457 (6.967)    0.267 (10.261) 
          Median                       49.297             2.009            51.400             0.175     
          Min - Max                 40.74 - 62.71    -18.30 - 16.74     38.67 - 64.61    -19.35 - 20.03 
        WEEK 3 DAY 22                                                                                   
          n                              15                15                15                15       
          Mean (SD)                47.589 (9.787)    -2.539 (14.436)   49.409 (8.233)    -0.781 (11.018)
          Median                       46.684            -1.599            49.126             0.823     
          Min - Max                 31.68 - 60.78    -29.72 - 17.50     34.70 - 59.13    -15.90 - 15.60 
        WEEK 4 DAY 29                                                                                   
          n                              15                15                15                15       
          Mean (SD)                50.868 (5.565)     0.740 (8.978)    48.702 (9.926)    -1.488 (12.483)
          Median                       50.915            -0.812            47.733             0.724     
          Min - Max                 43.52 - 63.79    -17.46 - 14.78     29.34 - 63.05    -24.46 - 17.60 
        WEEK 5 DAY 36                                                                                   
          n                              15                15                15                15       
          Mean (SD)                46.872 (6.924)    -3.256 (8.679)    52.382 (12.113)   2.192 (10.944) 
          Median                       47.348            -3.718            50.480             0.039     
          Min - Max                 32.92 - 55.85     -18.84 - 8.81     34.97 - 76.63    -16.57 - 17.23 
      \s\n
      Parameter: Weight
      
        ————————————————————————————————————————————————————————————
                                            C: Combination          
                                                       Change from  
                                   Value at Visit       Baseline    
        Analysis Visit                 (N=15)            (N=15)     
        ————————————————————————————————————————————————————————————
        SCREENING                                                   
          n                              15                 0       
          Mean (SD)                47.802 (9.718)        NE (NE)    
          Median                       44.999              NE       
          Min - Max                 33.02 - 62.96        NE - NE    
        BASELINE                                                    
          n                              15                         
          Mean (SD)                48.882 (6.494)                   
          Median                       49.514                       
          Min - Max                 36.44 - 60.34                   
        WEEK 1 DAY 8                                                
          n                              15                15       
          Mean (SD)                52.260 (8.638)     3.378 (9.764) 
          Median                       54.801             1.232     
          Min - Max                 36.10 - 63.51    -11.46 - 26.60 
        WEEK 2 DAY 15                                               
          n                              15                15       
          Mean (SD)                50.732 (10.876)   1.850 (13.271) 
          Median                       49.559             3.711     
          Min - Max                 28.09 - 73.67    -18.04 - 26.59 
        WEEK 3 DAY 22                                               
          n                              15                15       
          Mean (SD)                48.880 (7.877)    -0.002 (10.537)
          Median                       51.352             3.713     
          Min - Max                 27.81 - 63.18    -21.81 - 14.87 
        WEEK 4 DAY 29                                               
          n                              15                15       
          Mean (SD)                51.459 (6.985)     2.577 (9.123) 
          Median                       52.038             3.117     
          Min - Max                 40.20 - 63.54     -8.49 - 21.55 
        WEEK 5 DAY 36                                               
          n                              15                15       
          Mean (SD)                49.234 (6.227)     0.352 (9.015) 
          Median                       47.723             0.408     
          Min - Max                 39.80 - 58.46    -15.71 - 14.74 

