% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdsvals.r
\name{sds_pub}
\alias{sds_pub}
\title{Calculate SDS Values}
\usage{
sds_pub(
  value,
  pubstatus,
  sex,
  item,
  ref,
  type = "SDS",
  male = "male",
  female = "female"
)
}
\arguments{
\item{value}{vector of measurement values}

\item{pubstatus}{vector of Tanner stages coded 1 to 5}

\item{sex}{vector of sex}

\item{item}{name of the item e.g. "height"}

\item{ref}{RefGroup object}

\item{type}{"SDS" or "perc"}

\item{male}{coding of sex for male}

\item{female}{coding of sex for female}
}
\value{
vector containing SDS or percentile values
}
\description{
Calculate SDS values depending on the Tanner stage
}
\details{
The function takes a vector of measurement values, and of tanner stage and of sex
and a RefGroup object as arguments. It calculates the sds or percentile
values.
}
\author{
Mandy Vogel
}
