% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_temperatures.R
\name{filter_temperatures}
\alias{filter_temperatures}
\title{Quality filter for temperature records}
\usage{
filter_temperatures(temp_file, remove_value = NA,
  running_mean_filter = NA, running_mean_length = 3,
  min_extreme = NA, max_extreme = NA, max_missing_in_window = 1,
  missing_window_size = 9)
}
\arguments{
\item{temp_file}{file containing temperature data. Should have columns
c("Year","Month","Day","Temp" - and "Hour" for hourly data).}

\item{remove_value}{numeric value indicating 'no data'.}

\item{running_mean_filter}{deviation from a running mean over all temperature
data that identifies a value as an erroneous outlier.}

\item{running_mean_length}{number of records to be included in a running mean.}

\item{min_extreme}{lowest plausible temperature on the record. All lower ones are removed.}

\item{max_extreme}{highest plausible temperature on the record. All higher ones are removed.}

\item{max_missing_in_window}{maximum share of values (0..1) in a running window of size
missing_window_size around each value that can be missing. If this is exceeded, the value
is removed.}

\item{missing_window_size}{size of the window used for checking for missing values.}
}
\value{
filtered temperature dataset, from which records identified as erroneous were removed.
}
\description{
This function attempts to remove erroneous temperature readings. This is
tricky because of the wide range of errors that can occur, so this isn't
necessarily sufficient for problems of particular records.
}
\examples{


weather<-fix_weather(KA_weather[which(KA_weather$Year>2009),])

hourtemps<-stack_hourly_temps(weather, latitude=50.4)

filtered<-filter_temperatures(hourtemps$hourtemps,remove_value=-99,
  running_mean_filter=3)

}
\author{
Eike Luedeling
}
\keyword{utility}
