% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-equal.R
\name{chk_equal}
\alias{chk_equal}
\alias{vld_equal}
\title{Check Equal}
\usage{
chk_equal(x, y, tolerance = sqrt(.Machine$double.eps), x_name = NULL)

vld_equal(x, y, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{The object to check.}

\item{y}{An object to check against.}

\item{tolerance}{A non-negative numeric scalar.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is equal (identical within tolerance) to y using

\code{vld_true(all.equal(x, y, tolerance))}
}
\section{Functions}{
\itemize{
\item \code{vld_equal}: Validate Equal
}}

\examples{
# chk_equal
chk_equal(1, 1.00000001)
try(chk_equal(1, 1.0000001))
chk_equal(1, 1L)
chk_equal(c(x = 1), c(x = 1L))
try(chk_equal(c(x = 1), c(y = 1L)))
vld_equal(1, 1.00000001)
}
\seealso{
Other chk_equals: 
\code{\link{chk_equivalent}()},
\code{\link{chk_identical}()}
}
\concept{chk_equals}
