% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{err}
\alias{err}
\alias{wrn}
\alias{msg}
\title{Stop, Warning and Message Messages}
\usage{
err(..., n = NULL, tidy = TRUE, .subclass = NULL)

wrn(..., n = NULL, tidy = TRUE, .subclass = NULL)

msg(..., n = NULL, tidy = TRUE, .subclass = NULL)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{n}{The value of n for converting \code{sprintf}-like types.}

\item{tidy}{A flag specifying whether capitalize the first character and add a missing period.}

\item{.subclass}{A string of the class of the error message.}
}
\description{
The functions call \code{\link[=message_chk]{message_chk()}} to process
the message and then
\code{\link[rlang:abort]{rlang::abort()}}, \code{\link[rlang:abort]{rlang::warn()}} and
\code{\link[rlang:abort]{rlang::inform()}}, respectively.
}
\details{
The user can set the subclass.
}
\section{Functions}{
\itemize{
\item \code{err}: Error

\item \code{wrn}: Warning

\item \code{msg}: Message
}}

\examples{

# err
try(err("there \%r \%n problem value\%s", n = 2))

# wrn
wrn("there \%r \%n problem value\%s", n = 2)

# msg
msg("there \%r \%n problem value\%s", n = 2)
}
