% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-not-subset.R
\name{chk_not_subset}
\alias{chk_not_subset}
\title{Check Not Subset}
\usage{
chk_not_subset(x, values, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A vector of the permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if not all values in values using

\code{!any(x \%in\% values) || !length(x)}
}
\examples{
# chk_not_subset
chk_not_subset(11, 1:10)
try(chk_not_subset(1, 1:10))
}
\seealso{
Other chk_set: 
\code{\link{chk_join}()},
\code{\link{chk_orderset}()},
\code{\link{chk_superset}()},
\code{\link{vld_not_subset}()},
\code{\link{vld_orderset}()}
}
\concept{chk_set}
