\name{dcm.design.sort}
\alias{dcm.design.sort}
\title{INTERNAL: Append other design variables}
\description{Internal function to append card, version and task variables to design.
}

\usage{
dcm.design.sort(design, nb, sets, alts)
}

\arguments{
  \item{design}{The levels-coded design generated by either \code{dcm.design} or\cr
  \code{dcm.design.cand}.}
  \item{nb}{The number of blocks or versions in the final design.}
  \item{sets}{The number of choice sets in \emph{each version} of the final design.}
  \item{alts}{The number of alternatives in each choice set.}
}

\details{
  This function randomizes the order of rows within each block of the design using \code{runif} and appends
  card, version and task variables as appropriate.
  
  This function is called internally by \code{dcm.design} and \code{dcm.design.cand}.
} 

\value{
  A data frame containing the levels coded design with rows randomized within block, and with card, version 
  and task variables appended. 
}

\seealso{\code{dcm.design}, \code{dcm.design.cand}, \code{tradeoff.des}}

\examples{
## INTERNAL USE ONLY
}