% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWhitehead.R
\name{addWhitehead}
\alias{addWhitehead}
\title{Add Whitehead's Broad Street pump neighborhood.}
\usage{
addWhitehead(pump = "Broad Street", radius = 210, color = "black",
  line.type = "solid", vestry = FALSE, ...)
}
\arguments{
\item{pump}{Character. The name of the pump, the street name where it is located. See \code{pumps} or \code{pumps.vestry}.}

\item{radius}{Numeric. Distance from a pump in yards}

\item{color}{Character. Color of circle.}

\item{line.type}{Character. Circle line type.}

\item{vestry}{Logical. TRUE uses the 14 pumps and locations from Vestry report. FALSE uses original 13 pumps.}

\item{...}{Additional plotting parameters.}
}
\value{
Draws a circle, based on multiple line segments, to a graphics plot.
}
\description{
Adds a circle with a given radius from a specified water pump. By default, the function draws Whitehead's Broad Street pump neighborhood: a circle, centered on the Broad Street pump, with a radius of 210 yards.
}
\examples{
snowMap(add.landmarks = FALSE)
addWhitehead()
}
\seealso{
\code{\link{snowMap}},
\code{\link{addKernelDensity}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addSnow}},
\code{\link{addVoronoi}}

\code{\link{addLandmarks}}
}
