% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{road.segments}
\alias{road.segments}
\title{Dodson and Tobler's street data transformed into road segments.}
\format{A data frame with 657 observations and 7 variables. The data describe the straight line segments used to recreate the roads on Snow's map.
\describe{
  \item{\code{street}}{numeric street ID, which range between 1 and 528}
  \item{\code{id}}{character segment ID}
  \item{\code{name}}{road name}
  \item{\code{x1}}{x-coordinate of first endpoint}
  \item{\code{y1}}{y-coordinate of first endpoint}
  \item{\code{x2}}{x-coordinate of second endpoint}
  \item{\code{y2}}{y-coordinate of second endpoint}
}}
\usage{
road.segments
}
\description{
This data set transforms Dodson and Tobler's street data to give each straight line segment of a "road" a unique ID.
}
\section{Notes}{
 \code{\link{roadSegments}} documents the code for these data.
}

\seealso{
\code{\link{roads}}

\code{vignette}("road.names")

\code{\link{streetNameLocator}}

\code{\link{streetNumberLocator}}

\code{\link{segmentLocator}}
}
\keyword{datasets}
