% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhoodCases.R
\name{addNeighborhoodCases}
\alias{addNeighborhoodCases}
\title{Add observed cases by neighborhood.}
\usage{
addNeighborhoodCases(pump.subset = NULL, pump.select = NULL,
  metric = "walking", type = "stack.base", token = "point",
  text.size = 0.5, pch = 16, point.size = 0.5, vestry = FALSE,
  weighted = TRUE, color = NULL, case.location = "nominal",
  observed = TRUE, alpha.level = 0.5, multi.core = FALSE)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to subset from the neighborhoods defined by \code{pump.select}. Negative selection possible. \code{NULL} uses all pumps in \code{pump.select}.}

\item{pump.select}{Numeric. Numeric vector of pump IDs that define which pump neighborhoods to consider (i.e., specify the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{metric}{Character. Type of neighborhood: "euclidean" or "walking".}

\item{type}{Character. Type of case: "stack.base" (base of stack), or "stack" (entire stack). For observed = TRUE.}

\item{token}{Character. Type of token to plot: "point" or "id".}

\item{text.size}{Numeric. Size of case ID text.}

\item{pch}{Numeric.}

\item{point.size}{Numeric.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest walking path weighted by road length. \code{FALSE} computes shortest walking path in terms of the number of nodes.}

\item{color}{Character. Use a single color for all paths. \code{NULL} uses neighborhood colors defined by \code{snowColors().}}

\item{case.location}{Character. For \code{metric = "euclidean"}: "address" uses \code{ortho.proj}; "nominal" uses \code{fatalities}.}

\item{observed}{Logical. TRUE is observed; FALSE is expected or simulated.}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}
}
\description{
Add cases to a plot as "address" or "fatalities" and as points or IDs.
}
\examples{
\donttest{

snowMap(add.cases = FALSE)
addNeighborhoodCases(pump.subset = c(6, 10))

snowMap(add.cases = FALSE)
addNeighborhoodCases(pump.select = c(6, 10))
}
}
