% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWalkingPath.R
\name{addWalkingPath}
\alias{addWalkingPath}
\title{Add the shortest walking path between a selected cases or pumps.}
\usage{
addWalkingPath(origin = 1, destination = NULL, type = "case-pump",
  observed = TRUE, weighted = TRUE, vestry = FALSE,
  distance.unit = "meter", time.unit = "second", walking.speed = 5,
  unit.posts = "distance", unit.interval = NULL, alpha.level = 1)
}
\arguments{
\item{origin}{Numeric or Integer. Numeric ID of case or pump.}

\item{destination}{Numeric or Integer. Numeric ID(s) of case(s) or pump(s). Exclusion is possible via negative selection (e.g., -7). Default is \code{NULL}: this returns closest pump or "anchor" case. Character landmark name (case insensitive).}

\item{type}{Character "case-pump", "cases" or "pumps".}

\item{observed}{Logical. Use observed or "simulated" expected data.}

\item{weighted}{Logical. \code{TRUE} computes shortest path in terms of road length. \code{FALSE} computes shortest path in terms of nodes.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{distance.unit}{Character. Unit of distance: "meter", "yard" or "native". "native" returns the map's native scale. \code{unit} is meaningful only when "weighted" is \code{TRUE}. See \code{vignette("roads")} for information on unit distances.}

\item{time.unit}{Character. "hour", "minute", or "second".}

\item{walking.speed}{Numeric. Walking speed in km/hr.}

\item{unit.posts}{Character. "distance" for mileposts; "time" for timeposts.}

\item{unit.interval}{Numeric. Sets interval between posts: for "distance", the default is 50 meters; for "time", the default is 60 seconds.}

\item{alpha.level}{Numeric. Alpha level transparency for path: a value in [0, 1].}
}
\value{
An R list with two elements: a character vector of path nodes and a data frame summary.
}
\description{
Add the shortest walking path between a selected cases or pumps.
}
\note{
The function uses a case's "address" (i.e., a stack's "anchor" case) to compute distance. Time is computed using cholera::distanceTime(). Adam and Eve Court, and Falconberg Court and Falconberg Mews, are disconnected from the larger road network; they form two isolated subgraphs. This has two consequences: first, only cases on Adam and Eve Court can reach pump 2 and those cases cannot reach any other pump; second, cases on Falconberg Court and Mews cannot reach any pump. Unreachable pumps will return distances of \code{Inf}. Arrow points represent mileposts or timeposts to the destination.
}
\examples{
streetNameLocator("broad street", zoom = TRUE, highlight = FALSE,
  add.subtitle = FALSE)
addWalkingPath(447)
}
