% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WorldClim_data.R
\name{worldclim_data}
\alias{worldclim_data}
\title{Download WorldClim v2.1 Bioclimatic Data}
\usage{
worldclim_data(period = 'current', variable = 'bioc', year = '2030',
gcm = 'mi', ssp = '126', resolution = 10, path = NULL)
}
\arguments{
\item{period}{Character. Can be 'current' or 'future'.}

\item{variable}{Character. Specifies which variables to retrieve. Possible entries are:
'tmax', 'tmin', 'prec', and/or 'bioc'.}

\item{year}{Character or vector. Specifies the year(s) to retrieve data for. Possible entries are:
'2030', '2050', '2070', and/or '2090'.}

\item{gcm}{Character or vector. Specifies the GCM(s) to consider for future scenarios. See the table below for available options:

| **CODE** | **GCM**              |
|----------|----------------------|
| ac       | ACCESS-CM2           |
| ae       | ACCESS-ESM1-5        |
| bc       | BCC-CSM2-MR          |
| ca       | CanESM5              |
| cc       | CanESM5-CanOE        |
| ce       | CMCC-ESM2            |
| cn       | CNRM-CM6-1           |
| ch       | CNRM-CM6-1-HR        |
| cr       | CNRM-ESM2-1          |
| ec       | EC-Earth3-Veg        |
| ev       | EC-Earth3-Veg-LR     |
| fi       | FIO-ESM-2-0          |
| gf       | GFDL-ESM4            |
| gg       | GISS-E2-1-G          |
| gh       | GISS-E2-1-H          |
| hg       | HadGEM3-GC31-LL      |
| in       | INM-CM4-8            |
| ic       | INM-CM5-0            |
| ip       | IPSL-CM6A-LR         |
| me       | MIROC-ES2L           |
| mi       | MIROC6               |
| mp       | MPI-ESM1-2-HR        |
| ml       | MPI-ESM1-2-LR        |
| mr       | MRI-ESM2-0           |
| uk       | UKESM1-0-LL          |}

\item{ssp}{Character or vector. SSP(s) for future data. Possible entries are: '126', '245', '370', and/or '585'.}

\item{resolution}{Numeric. Specifies the resolution. Possible values are 10, 5, 2.5, or 30 arcseconds.}

\item{path}{Character. Directory path to save the downloaded files. Default is NULL.}
}
\value{
This function does not return any value.
}
\description{
This function allows downloading data from WorldClim v2.1 (https://www.worldclim.org/data/index.html) for multiple GCMs, time periods, and SSPs.
}
\details{
This function creates a folder in \code{path}.
All downloaded data will be stored in this folder.
Note: While it is possible to retrieve a large volume of data, it is not recommended to do so due to the large file sizes.
For example, datasets at 30 arcseconds resolution can exceed 4 GB. If the function fails to retrieve large datasets,
consider increasing the timeout by setting \code{options(timeout = 600)}.
}
\examples{
\donttest{
# download data from multiple periods:
year <- c("2050", "2090")
worldclim_data("future", "bioc", year, "mi", "126", 10, path=tempdir())

# download data from one specific period:
worldclim_data("future", "bioc", "2070", "mi", "585", 10, path=tempdir())
}

}
\references{
https://www.worldclim.org/data/index.html
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
