% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{chopthin}
\alias{chopthin}
\title{The Chopthin Resampler}
\usage{
chopthin(w, N, eta = 5.828427, normalise = TRUE, checks = TRUE)
}
\arguments{
\item{w}{a vector of weights}

\item{N}{target number of particles}

\item{eta}{upper bound on the ratio between the weights. Must be >=4.
If eta=Inf then only thinnig is performed, requiring the number of weights to be at least N.}

\item{normalise}{Flag for controlling if the returned weights should
be normalised. If TRUE (default) then the sum of the returned
weights will sum to N. If FALSE then the returned weights have
the same sum as the original weights (within the numerical precision).}

\item{checks}{Flag controlling if checks on the input and the result should be performed. Default TRUE.}
}
\value{
A list with two elements: new weights and indices
of the ancestors of the new particles. The weights are normalised to add up to N.
}
\description{
A fast implementation of the Chopthin resampler. Can be used as the
resampling step in particle filters and in sequential Monte Carlo.
}
\examples{
chopthin(runif(10),N=10)
chopthin(runif(10),N=20,4)
chopthin(runif(10),N=5)
chopthin(runif(10),N=1)
}
\references{
A Gandy and F. D-H Lau. The chopthin algorithm for
resampling. arXiv:1502.07532 [stat.CO], 2015
}

