% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_peaktable.R
\name{get_peaktable}
\alias{get_peaktable}
\title{Convert peak list into an ordered peak table.}
\usage{
get_peaktable(
  peak_list,
  chrom_list,
  response = c("area", "height"),
  use.cor = FALSE,
  hmax = 0.2,
  plot_it = FALSE,
  ask = plot_it,
  clust = c("rt", "sp.rt"),
  sigma.t = NULL,
  sigma.r = 0.5,
  deepSplit = FALSE,
  verbose = FALSE,
  out = c("data.frame", "matrix")
)
}
\arguments{
\item{peak_list}{A \code{peak_list} object created by \code{\link{get_peaks}},
containing a nested list of peak tables: the first level is the
sample, and the second level is the spectral component. Every component is
described by a data.frame where every row is one peak, and the columns contain
information on various peak parameters.}

\item{chrom_list}{A list of chromatographic matrices.}

\item{response}{Indicates whether peak area or peak height is to be used
as intensity measure. Defaults to \code{area} setting.}

\item{use.cor}{Logical. Indicates whether to use corrected retention times
(by default) or raw retention times (not advised!).}

\item{hmax}{Height at which the complete linkage dendrogram will be cut. Can
be interpreted as the maximal inter-cluster retention time difference.}

\item{plot_it}{Logical. If TRUE, for every component a stripplot will be
shown indicating the clustering.}

\item{ask}{Logical. Ask before showing new plot?}

\item{clust}{Specify whether to perform hierarchical clustering based on
spectral similarity and retention time (\code{sp.rt}) or retention time alone
(\code{rt}). Defaults to \code{rt}. The \code{sp.rt} option is experimental
and should be used with caution.}

\item{sigma.t}{Width of gaussian in retention time distance function.
Controls weight given to retention time if \code{sp.rt} is selected.}

\item{sigma.r}{Width of gaussian in spectral similarity function. Controls
weight given to spectral correlation if \code{sp.rt} is selected.}

\item{deepSplit}{Logical. Controls sensitivity to cluster splitting. If
\code{TRUE}, function will return more smaller clusters. See documentation for
\code{\link{cutreeDynamic}} for additional information.}

\item{verbose}{Logical. Whether to print warning when combining peaks into
single time window. Defaults to \code{FALSE}.}

\item{out}{Specify \code{data.frame} or \code{matrix} as output. Defaults to
\code{data.frame}.}
}
\value{
The function returns a \code{peak_table} object, consisting of the following
elements:
\itemize{
\item \code{tab}: the peak table itself -- a data-frame of intensities in a
sample x peak configuration.
\item \code{pk_meta}: A data.frame containing peak meta-data (e.g. the spectral component,
peak number, and average retention time).
\item \code{sample_meta}: A data.frame of sample meta-data. Must be added using
\code{\link{attach_metadata}}).
\item \code{ref_spectra}: A data.frame of reference spectra (in a wavelength x peak
configuration). Must be added using \code{\link{attach_ref_spectra}}
\item \code{args}: A vector of arguments given to \code{\link{get_peaktable}} to generate
the peak table.
}
}
\description{
Returns a peak_table object. The first slot contains a matrix of
intensities, where rows correspond to samples and columns correspond to
aligned features. The rest of the slots contain various meta-data about peaks,
samples, and experimental settings.
}
\details{
The function performs a complete linkage clustering of retention times across
all samples, and cuts at a height given by the user (which can be understood
as the maximal inter-cluster retention time difference) in the simple case
based on retention times. Clustering can also incorporate information about
spectral similarity using a distance function adapted from Broeckling et al.,
2014:
\deqn{latexascii}{e^{-\frac{(1-c_{ij})^2}{2\sigma_r^2}}* e^{-\frac{(1-(t_i-t_j)^2}{2\sigma_t^2}}}
If two peaks from the same sample are assigned to the same cluster, a warning
message is printed to the console. These warnings can usually be ignored, but
one could also consider reducing the \code{hmax} variable. However, this may
lead to splitting of peaks across multiple clusters. Another option is to
filter the peaks by intensity to remove small features.
}
\note{
Adapted from
\href{https://github.com/rwehrens/alsace/blob/master/R/getPeakTable.R}{getPeakTable}
function in the alsace package by Ron Wehrens.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sa_pr)
pks <- get_peaks(Sa_pr, lambdas = c('210'))
get_peaktable(pks, response = "area")
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Broeckling, C. D., Afsar F.A., Neumann S., Ben-Hur A., and Prenni J.E. 2014.
RAMClust: A Novel Feature Clustering Method Enables Spectral-Matching-Based
Annotation for Metabolomics Data. \emph{Anal. Chem.}
\bold{86}:6812-6817. \doi{10.1021/ac501530d}
\item Wehrens, R., Carvalho, E., Fraser, P.D. 2015. Metabolite profiling in
LC–DAD using multivariate curve resolution: the alsace package for R. \emph{
Metabolomics} \bold{11}:143-154. \doi{10.1007/s11306-014-0683-5}
}
}
\seealso{
\code{\link{attach_ref_spectra}} \code{\link{attach_metadata}}
}
\author{
Ethan Bass
}
