% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dygraphs.R
\name{make_dygraph}
\alias{make_dygraph}
\title{Plot a time series from a data frame through dygraph's interactive html plot interface}
\usage{
make_dygraph(
  dt,
  value,
  date,
  groups = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma"
)
}
\arguments{
\item{dt}{data.frame containing the data to plot. It must have a numerical variable, a date variable, and optionally a grouping variable to split the data and plot them as individual time series inside the same plot.}

\item{value}{Name of the column of the data frame containing the numerical variables of the time series.}

\item{date}{Name of the column containing the date variable. It must be already a date or time object.}

\item{groups}{Name of the columns containing the different groups.}

\item{y_axis_label}{Label for the y axis. x axis is the date (or time) so it is not needed}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot. Default is RColorBrewer's Paired and Spectral colors concatenated.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}
}
\value{
A dygraph of the numerical variable specified, optionally split by the values of 'groups.'
}
\description{
Plot a time series from a data frame through dygraph's interactive html plot interface
}
\examples{
dat <- data.frame(x = c(rnorm(100, 2, 4),
                        rnorm(100, 6, 1),
                        rnorm(100, 8, 2)),
                  group = c(rep('A', 100),
                            rep('B', 100),
                            rep('C', 100)),
                  date = rep(seq(as.Date("2020-01-01"),
                                 as.Date("2020-04-09"),
                                 'days'),
                             3))
make_dygraph(dt = dat,
             value = 'x',
             date = 'date')
make_dygraph(dt = dat,
             value = 'x',
             groups = 'group',
             date = 'date')
}
