% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{separate_cifti_wrapper}
\alias{separate_cifti_wrapper}
\title{\code{separate_cifti} wrapper}
\usage{
separate_cifti_wrapper(
  cifti_fname,
  brainstructures = NULL,
  ROI_brainstructures = NULL,
  sep_fnames = NULL,
  write_dir = NULL,
  wb_path = NULL
)
}
\arguments{
\item{cifti_fname}{File path of CIFTI-format data (ending in ".d*.nii").}

\item{brainstructures}{Character vector indicating which brain structure(s) 
 to obtain: \code{"left"} (left cortical surface), \code{"right"} (right 
 cortical surface) and/or \code{"subcortical"} (subcortical and cerebellar
 gray matter). Can also be \code{"all"} (obtain all three brain structures). 
 Default: \code{c("left","right")} (cortical surface only).

 If a brain structure is indicated but does not exist, a warning will be
 raised and that brain structure will be skipped.}

\item{ROI_brainstructures}{Character vector indicating which ROIs should be 
 obtained. \code{NULL} (default) to not get any ROIs. Otherwise, this should 
 be a subset of the \code{brainstructures} argument. 

ROIs are typically the medial wall mask for the cortex and subcortical mask
 for the subcortex.}

\item{sep_fnames}{(Optional) Where to write the separated files (override
 their default file names). This is a named list 
 where each entry's name is a file type label, and each entry's value
 is a file name indicating where to write the corresponding separated file. 
 The recognized file type labels are: "cortexL", "cortexR", 
 "ROIcortexL", "ROIcortexR", "subcortVol", and "subcortLabs".
 
 Entry values can be \code{NULL}, in which case a default file name will be 
 used: see \code{\link{cifti_component_suffix}}. Default file names
 will also be used for files that need to be separated/written but without a
 corresponding entry in \code{sep_fnames}.
 
 Entries in \code{sep_fnames} will be ignored if they are not needed
 based on \code{[ROI_]brainstructures}. For example, if
 \code{brainstructures="left"}, then \code{sep_fnames$cortexR} will be 
 ignored if specified. 

 The \code{write_dir} argument can be used to place each separated file in
 the same directory.}

\item{write_dir}{Where should the separated
 files be placed? \code{NULL} (default) will write them to
 the current working directory.

 \code{write_dir} must already exist, or an error will occur.}

\item{wb_path}{(Optional) Path to Connectome Workbench folder or executable. 
If not provided, should be set with 
\code{ciftiTools.setOption("wb_path", "path/to/workbench")}.}
}
\value{
The return value of the \code{separate_cifti} call
}
\description{
Calls \code{separate_cifti} using the file names listed in the
 argument \code{sep_fnames}.
}
\details{
Currently used by \code{read_cifti} and \code{resample_cifti}.
}
\keyword{internal}
