% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cifti.R
\name{write_cifti_components}
\alias{write_cifti_components}
\title{Write CIFTI component files from a \code{"xifti"} object}
\usage{
write_cifti_components(
  xifti,
  extn_cifti,
  write_dir = NULL,
  mwall_fill = NA,
  subcort_fill = 0,
  verbose = FALSE
)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{extn_cifti}{The CIFTI extension e.g. "dtseries.nii"}

\item{write_dir}{Where should the separated files be placed? \code{NULL}
(default) will write them to the current working directory.

\code{write_dir} must already exist, or an error will occur.}

\item{mwall_fill}{Value to use for the medial wall in the cortex GIFTIs.
Default: \code{NA}.}

\item{subcort_fill}{Value to use for out-of-mask voxels in the subcortex.
Default: \code{0}.}

\item{verbose}{Should occasional updates be printed? Default: \code{FALSE}.}
}
\value{
List of written files
}
\description{
Write metric GIFTIs for the cortical surface data and NIFTIs for the
subcortical labels and mask in a \code{"xifti"} object. Each present
brainstructure will be written; if a brainstructure is absent the
corresponding file is not written.
}
\keyword{internal}
