% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sampleKappa}
\alias{sampleKappa}
\title{Sample a value from the Bessel exponential distribution}
\usage{
sampleKappa(etag, eta)
}
\arguments{
\item{etag}{Numeric; This is \code{eta * g}, which should
\code{-R*cos(mu-theta_bar)}, where \code{R} is the posterior mean
resultant length, and \code{theta_bar} is the posterior mean, while
\code{mu} is the current value of the mean.}

\item{eta}{Integer; This is the posterior sample size, which is n + c where
c is the number of observations contained in the conjugate prior. For
uninformative, \code{c = 0} and \code{eta = n}.}
}
\value{
A sampled value \code{kappa} from the Bessel exponential
  distribution.
}
\description{
This is an implementation of the algorithm of Forbes and Mardia (2015) to
sample from the Bessel exponential distribution, which is the conditional
distribution of the concentration parameter of a von Mises distribution
given the mean \code{mu}. The distribution is proportional to \eqn{exp(-
\eta g \kappa)/I_0(\kappa)^\eta}. Note that \code{beta_0} in Forbes and
Mardia (2015) is renamed \code{g} here.
}
