% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.R
\name{ciu}
\alias{ciu}
\title{Create \code{ciu} object.}
\usage{
ciu(
  model,
  formula = NULL,
  data = NULL,
  in.min.max.limits = NULL,
  abs.min.max = NULL,
  input.names = NULL,
  output.names = NULL,
  predict.function = NULL,
  vocabulary = NULL
)
}
\arguments{
\item{model}{Model/"black-box" object (same parameter as \code{bb} for function
\link{ciu.new}).}

\item{formula}{Formula that describes input versus output values. Only to
be used together with \code{data} parameter.}

\item{data}{The training data used for training the model. If this parameter
is provided, a \code{formula} MUST be given also.
\code{ciu.new} attempts to infer the other parameters from
\code{data} and \code{formula}. i.e. \code{in.min.max.limits},
\code{abs.min.max}, \code{input.names}
and \code{output.names}. If those parameters are provided, then they
override the inferred ones.}

\item{in.min.max.limits}{matrix with one row per output and two columns,
where the first column indicates the minimal value and the second column
the maximal value for that input.}

\item{abs.min.max}{\link{data.frame} or \link{matrix} of min-max values of
outputs, one row per output, two columns (min, max).}

\item{input.names}{labels of inputs.}

\item{output.names}{labels of outputs.}

\item{predict.function}{can be supplied if a model that is not supported by
ciu should be used. As an example, this is the function for lda:\preformatted{
o.predict.function <- function(model, inputs) \{
    pred <- predict(model,inputs)
        return(pred$posterior)
\}}}

\item{vocabulary}{list of labels/concepts to be used when producing
explanations and what combination of inputs they correspond to. Example of
two intermediate concepts and a higher-level one that combines them:
\code{list(intermediate.concept1=c(1,2,3), intermediate.concept2=c(4,5), higher.level.concept=c(1,2,3,4,5))}}
}
\value{
\code{ciu} object.
}
\description{
Sets up a \code{ciu} object with the given parameters. This is not the same as
a \code{CIU} object as returned by the function \link{ciu.new}! a \code{ciu} object is a
\link{list} with all the parameter values needed for Contextual Importance and
Utility calculations, whereas a \code{CIU} object only exposes a set of methods
that can be called using the \code{$} operator. \code{CIU} provides the method
\verb{$as.ciu} for retrieving a \code{ciu} object from a \code{CIU} object.
}
\examples{
# Explaining the classification of an Iris instance with lda model.
# We use a versicolor (instance 100).
library(MASS)
test.ind <- 100
iris_test <- iris[test.ind, 1:4]
iris_train <- iris[-test.ind, 1:4]
iris_lab <- iris[[5]][-test.ind]
model <- lda(iris_train, iris_lab)

# Create CIU object
ciu <- ciu(model, Species~., iris)

# This can be used with explain method for getting CIU values
# of one or several inputs. Here we get CIU for all three outputs
# with input feature "Petal.Length" that happens to be the most important.
ciu.explain(ciu, iris_test, 1)

# It is, however, more convenient to use one of the graphical visualizations.
# Here's one using ggplot.
ciu.ggplot.col(ciu, iris_test)

}
\seealso{
\link{ciu.new}
}
\author{
Kary Främling
}
