% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{exports_list}
\alias{exports_list}
\title{List}
\usage{
exports_list(type = NULL, author = NULL, status = NULL, hidden = NULL,
  archived = NULL, limit = NULL, page_num = NULL, order = NULL,
  order_dir = NULL)
}
\arguments{
\item{type}{string optional. If specified, return exports of these types. It accepts a comma-separated list, possible values are 'database' and 'gdoc'.}

\item{author}{string optional. If specified, return exports from this author. It accepts a comma-separated list of author ids.}

\item{status}{string optional. If specified, returns export with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'failed', 'succeeded', 'idle', 'scheduled'.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at, last_run.updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this export.}
\item{name}{string, The name of this export.}
\item{type}{string, The type of export.}
\item{createdAt}{string, The creation time for this export.}
\item{updatedAt}{string, The last modification time for this export.}
\item{state}{string, }
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
}
\description{
List
}
