% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_post_batches}
\alias{imports_post_batches}
\title{Upload multiple files to Redshift}
\usage{
imports_post_batches(file_ids, schema, table, remote_host_id, credential_id,
  column_delimiter = NULL, first_row_is_header = NULL, compression = NULL,
  hidden = NULL)
}
\arguments{
\item{file_ids}{array required. The file IDs for the import.}

\item{schema}{string required. The destination schema name. This schema must already exist in Redshift.}

\item{table}{string required. The destination table name, without the schema prefix. This table must already exist in Redshift.}

\item{remote_host_id}{integer required. The ID of the destination database host.}

\item{credential_id}{integer required. The ID of the credentials to be used when performing the database import.}

\item{column_delimiter}{string optional. The column delimiter for the file. Valid arguments are "comma", "tab", and "pipe". If unspecified, defaults to "comma".}

\item{first_row_is_header}{boolean optional. A boolean value indicating whether or not the first row is a header row. If unspecified, defaults to false.}

\item{compression}{string optional. The type of compression. Valid arguments are "gzip", "zip", and "none". If unspecified, defaults to "gzip".}

\item{hidden}{boolean optional. The hidden status of the item.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the import.}
\item{schema}{string, The destination schema name. This schema must already exist in Redshift.}
\item{table}{string, The destination table name, without the schema prefix. This table must already exist in Redshift.}
\item{remoteHostId}{integer, The ID of the destination database host.}
\item{state}{string, The state of the run; one of "queued", "running", "succeeded", "failed", or "cancelled".}
\item{startedAt}{string, The time the last run started at.}
\item{finishedAt}{string, The time the last run completed.}
\item{error}{string, The error returned by the run, if any.}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Upload multiple files to Redshift
}
