% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{queries_list}
\alias{queries_list}
\title{List}
\usage{
queries_list(database_id = NULL, author_id = NULL, created_before = NULL,
  exclude_results = NULL, hidden = NULL, limit = NULL, page_num = NULL,
  order = NULL, order_dir = NULL)
}
\arguments{
\item{database_id}{integer optional. The database ID.}

\item{author_id}{integer optional. The author of the query.}

\item{created_before}{string optional. An upper bound for the creation date of the query.}

\item{exclude_results}{boolean optional. If true, does not return cached query results.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to created_at. Must be one of: created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The query ID.}
\item{database}{integer, The database ID.}
\item{sql}{string, The SQL to execute.}
\item{credential}{integer, The credential ID.}
\item{resultRows}{array, A preview of rows returned by the query.}
\item{resultColumns}{array, A preview of columns returned by the query.}
\item{scriptId}{integer, The ID of the script associated with this query.}
\item{exception}{string, Deprecated and not used.}
\item{error}{string, The error message for this run, if present.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{finishedAt}{string, The end time of the last run.}
\item{state}{string, The state of the last run.}
\item{lastRunId}{integer, The ID of the last run.}
\item{previewRows}{integer, The number of rows to save from the query's result (maximum: 100).}
\item{startedAt}{string, The start time of the last run.}
\item{reportId}{integer, The ID of the report associated with this query.}
}
\description{
List
}
