% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_kubernetes}
\alias{clusters_list_kubernetes}
\title{List Kubernetes Clusters}
\usage{
clusters_list_kubernetes(organization_slug = NULL, limit = NULL,
  page_num = NULL, order = NULL, order_dir = NULL)
}
\arguments{
\item{organization_slug}{string optional. The slug of this cluster's organization.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to organization_id. Must be one of: organization_id, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of this cluster.}
\item{organizationId}{string, The id of this cluster's organization.}
\item{organizationSlug}{string, The slug of this cluster's organization.}
\item{clusterPartitions}{array, An array containing the following fields: 
\itemize{
\item clusterPartitionId integer, The ID of this cluster partition.
\item name string, The name of the cluster partition.
\item labels array, Labels associated with this partition.
\item instanceConfigs array, The instances configured for this cluster partition.
\item defaultInstanceConfigId integer, The id of the InstanceConfig that is the default for this partition.
}}
\item{isNatEnabled}{boolean, Whether this cluster needs a NAT gateway or not.}
}
\description{
List Kubernetes Clusters
}
