% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination_helpers.R
\name{fetch_until}
\alias{fetch_until}
\title{Retrieve some results from a paginated endpoint}
\usage{
fetch_until(fn, .until, ...)
}
\arguments{
\item{fn}{The API function to be called.}

\item{.until}{A function or formula which returns a boolean value.
\code{.until} will be called with each item from the API response. When
\code{.until} returns \code{TRUE} iteration will stop and \code{fetch_until}
will return all responses accumulated so far.}

\item{...}{Arguments passed to \code{fn}.}
}
\value{
A \code{list} with the concatenated results of each page of \code{fn}.
}
\description{
\code{fetch_until} will retrieve paginated results until a condition is met.
This is useful when searching for a particular value or record.
}
\examples{
\dontrun{
columns <- fetch_until(tables_list_columns,
                       .until = function(x) x == "voterbase_id")
}
}
\seealso{
Other pagination: \code{\link{fetch_all}}
}
\concept{pagination}
