% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_delete.R
\name{group_delete}
\alias{group_delete}
\title{Delete a group}
\usage{
group_delete(id, url = get_default_url(), key = get_default_key(), ...)
}
\arguments{
\item{id}{(character) The id of the group. Required.}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Delete a group
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org", key = getOption("ckan_demo_key"))

# create a group
(res <- group_create("lions", description="A group about lions"))

# show the group
group_show(res$id)

# delete the group
group_delete(res)
## or with it's id
# group_delete(res$id)
}
}
