% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cld3.R
\name{cld3}
\alias{cld3}
\alias{detect_language}
\alias{detect_language_mixed}
\alias{detect_language_multi}
\title{Compact Language Detector 3}
\usage{
detect_language(text)

detect_language_mixed(text, size = 3)
}
\arguments{
\item{text}{a string with text to classify or a connection to read from}

\item{size}{number of languages to detect}
}
\description{
The function \code{\link[=detect_language]{detect_language()}} is vectorised and guesses the the language of each string
in \code{text} or returns \code{NA} if the language could not reliably be determined. The function
\code{\link[=detect_language_multi]{detect_language_multi()}} is not vectorised and detects all languages inside the entire
character vector as a whole.
}
\examples{
# Vectorized best guess
text <- c("To be or not to be?", "Ce n'est pas grave.",
  "Hij heeft de klok horen luiden maar weet niet waar de klepel hangt.")
detect_language(text)

# Multiple languages in one text (doesn't seem to work well)
detect_language_mixed(text)
}
