% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_based_cleaning.R
\name{add_to_dictionary}
\alias{add_to_dictionary}
\title{Add an element to the data dictionary}
\usage{
add_to_dictionary(dictionary, option, value, grp, order = NULL)
}
\arguments{
\item{dictionary}{A data frame with the data dictionary}

\item{option}{A vector of strings with the new options that need to be added
to the dictionary.}

\item{value}{A vector with the values to be used when replacing the new
options.}

\item{grp}{A vector with the name of the column that contains the option
of interest.}

\item{order}{A numeric with the order of the new option.}
}
\value{
An object of type data frame. This is the new data dictionary with
an additional line that contains the details about the new options.
}
\description{
Add an element to the data dictionary
}
\examples{
test <- add_to_dictionary(
  dictionary = readRDS(system.file("extdata", "test_dict.RDS",
                       package = "cleanepi")),
  option     = "ml",
  value      = "male",
  grp        = "gender",
  order      = NULL
 )
}
