% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_based_cleaning.R
\name{detect_misspelled_options}
\alias{detect_misspelled_options}
\title{Detect misspelled options in columns to be cleaned}
\usage{
detect_misspelled_options(data, dictionary)
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}}

\item{dictionary}{A \code{<data.frame>} with the dictionary associated with
the input data. This is expected to be compatible with the
\pkg{matchmaker} package and must contain the following four columns:
\describe{
\item{\code{options}}{This column contains the current values used to
represent the different groups in the input data frame (required).}
\item{\code{values}}{The values that will be used to replace the current
options (required).}
\item{\code{grp}}{The name of the columns where every option belongs to
(required).}
\item{\code{orders}}{This defines the user-defined order of different options
(optional).}
}}
}
\value{
A \code{<list>} with the indexes of the misspelled values in every
column that needs to be cleaned.
}
\description{
Detect misspelled options in columns to be cleaned
}
\keyword{internal}
