% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clgeo_IsValid.R
\name{clgeo_IsValid}
\alias{clgeo_IsValid}
\title{clgeo_IsValid}
\usage{
clgeo_IsValid(sp, verbose = FALSE)
}
\arguments{
\item{sp}{object extending the \code{\link[sp]{Spatial-class}} as defined in \pkg{sp}}

\item{verbose}{object of class "logical". Default value is FALSE.}
}
\value{
an object of class "logical". TRUE if valid, FALSE otherwise
}
\description{
Wrapper method to try performing rgeos::gIsValid call and catch eventual
warnings or errors (in particular GEOS exceptions).
}
\examples{
\donttest{
 require(maptools)
 file <- system.file("extdata", "example.shp", package = "cleangeo")
 sp <- readShapePoly(file)
 clgeo_IsValid(sp)
}
}
\author{
Emmanuel Blondel \email{emmanuel.blondel1@gmail.com}
}
\keyword{IsValid}
\keyword{clean}
\keyword{gIsValid}
\keyword{geometry}
\keyword{summary}
\keyword{validity}

