% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliapp-docs.R
\name{themes}
\alias{themes}
\title{About cli themes}
\description{
CLI elements can be styled via a CSS-like language of selectors and
properties. Only a small subset of CSS3 is supported, and
a lot visual properties cannot be implemented on a terminal, so these
will be ignored as well.
}
\section{Adding themes}{

The style of an element is calculated from themes from four sources.
These form a stack, and the themes on the top of the stack take
precedence, over themes in the bottom.
\enumerate{
\item The cli package has a built-in theme. This is always active.
See \code{\link[=builtin_theme]{builtin_theme()}}.
\item When an app object is created via \code{\link[=start_app]{start_app()}}, the caller can
specify a theme, that is added to theme stack. If no theme is
specified for \code{\link[=start_app]{start_app()}}, the content of the \code{cli.theme} option
is used. Removed when the corresponding app stops.
\item The user may specify a theme in the \code{cli.user_theme} option. This
is added to the stack \emph{after} the app's theme (step 2.), so it can
override its settings. Removed when the app that added it stops.
\item Themes specified explicitly in \code{\link[=cli_div]{cli_div()}} elements. These are
removed from the theme stack, when the corresponding \code{\link[=cli_div]{cli_div()}}
elements are closed.
}
}

\section{Writing themes}{

A theme is a named list of lists. The name of each entry is a CSS
selector. Only a subset of CSS is supported:
\itemize{
\item Type selectors, e.g. \code{input} selects all \verb{<input>} elements.
\item Class selectors, e.g. \code{.index} selects any element that has a class
of "index".
\item ID selector. \verb{#toc} will match the element that has the ID "toc".
\item The descendant combinator, i.e. the space, that selects nodes
that are descendants of the first element. E.g. \verb{div span} will match
all \verb{<span>} elements that are inside a \verb{<div>} element.
}

The content of a theme list entry is another named list, where the
names are CSS properties, e.g. \code{color}, or \code{font-weight} or
\code{margin-left}, and the list entries themselves define the values of
the properties. See \code{\link[=builtin_theme]{builtin_theme()}} and \code{\link[=simple_theme]{simple_theme()}} for examples.
}

\section{Formatter callbacks}{

For flexibility, themes may also define formatter functions, with
property name \code{fmt}. These will be called once the other styles are
applied to an element. They are only called on elements that produce
output, i.e. \emph{not} on container elements.
}

\section{Supported properties}{

Right now only a limited set of properties are supported. These include
left, right, top and bottom margins, background and foreground colors,
bold and italic fonts, underlined text. The \code{before} and \code{after}
properties are supported to insert text before and after the
content of the element.

The current list of properties:
\itemize{
\item \code{after}: A string literal to insert after the element. It can also be
a function that returns a string literal. Supported by all inline
elements, list items, alerts and rules.
\item \code{background-color}: An R color name, or HTML hexadecimal color.
It can be applied to most elements (inline elements, rules, text,
etc.), but the background of containers is not colored properly
currently.
\item \code{before}: A string literal to insert before the element. It can also be
a function that returns a string literal. Supported by all inline
elements, list items, alerts and rules.
\item \code{class-map}: Its value can be a named list, and it specifies how
R (S3) class names are mapped to cli class names. E.g.
\code{list(fs_path = "file")} specifies that \code{fs_path} objects (from the fs
package) should always print as \code{.file} objects in cli.
\item \code{color}: Text color, an R color name or a HTML hexadecimal color. It
can be applied to most elements that are printed.
\item \code{collapse}: Specifies how to collapse a vector, before applying
styling. If a character string, then that is used as the separator.
If a function, then it is called, with the vector as the only
argument.
\item \code{digits}: Number of digits after the decimal point for numeric inline
element of class \code{.val}.
\item \code{fmt}: Generic formatter function that takes an input text and returns
formatted text. Can be applied to most elements. If colors are in use,
the input text provided to \code{fmt} already includes ANSI sequences.
\item \code{font-style}: If \code{"italic"} then the text is printed as cursive.
\item \code{font-weight}: If \code{"bold"}, then the text is printed in boldface.
\item \code{line-type}: Line type for \code{\link[=cli_rule]{cli_rule()}}.
\item \code{list-style-type}: String literal or functions that returns a string
literal, to be used as a list item marker in un-ordered lists.
\item \code{margin-bottom}, \code{margin-left}, \code{margin-right}, \code{margin-top}: Margins.
\item \code{padding-left}, \code{padding-right}: This is currently used the same way
as the margins, but this might change later.
\item \code{start}: Integer number, the first element in an ordered list.
\item \code{string_quote}: Quoting character for inline elements of class \code{.val}.
\item \code{text-decoration}: If \code{"underline"}, then underlined text is created.
\item \code{text-exdent}: Amount of indentation from the second line of wrapped
text.
\item \code{transform}: A function to call on glue substitutions, before
collapsing them. Note that \code{transform} is applied prior to
implementing color via ANSI sequences.
\item \code{vec_last}: The last separator when collapsing vectors.
\item \code{vec_sep}: The separator to use when collapsing vectors.
\item \code{vec_trunc}: Vectors longer than this will be truncated. Defaults to
100.
}

More properties might be added later. If you think that a property is
not applied properly to an element, please open an issue about it in
the cli issue tracker.
}

\section{Examples}{

Color of headings, that are only active in paragraphs with an
'output' class:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  "par.output h1" = list("background-color" = "red", color = "#e0e0e0"),
  "par.output h2" = list("background-color" = "orange", color = "#e0e0e0"),
  "par.output h3" = list("background-color" = "blue", color = "#e0e0e0")
)
}\if{html}{\out{</div>}}

Create a custom alert type:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  ".alert-start" = list(before = symbol$play),
  ".alert-stop"  = list(before = symbol$stop)
)
}\if{html}{\out{</div>}}
}

