% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_normal.R
\name{aemet_normal}
\alias{aemet_normal}
\alias{aemet_normal_clim}
\alias{aemet_normal_clim_all}
\title{Normal climatology values}
\usage{
aemet_normal_clim(station = NULL, verbose = FALSE, return_sf = FALSE)

aemet_normal_clim_all(verbose = FALSE, return_sf = FALSE)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}}) or "all" for all the stations.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{sf} spatial object? If \code{FALSE}
(the default value) it returns a tibble. Note that you need to
have the \code{sf} package installed.}
}
\value{
A tibble or a \code{sf} object.
}
\description{
Get normal climatology values for a station (or all the stations with
\code{aemet_normal_clim_all()}. Standard climatology from 1981 to 2010.
}
\note{
Code modified from project
\url{https://github.com/SevillaR/aemet}
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(tibble)
obs <- aemet_normal_clim(c("9434", "3195"))
glimpse(obs)
\dontshow{\}) # examplesIf}
}
\seealso{
Other aemet_api_data: 
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
